set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9301596';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1111',
      '11314131',
      '10243102',
      NULL,
      '12010120',
      NULL,
      NULL,
      '24140430',
      '30132411',
      NULL,
      '12430131',
      '03420102',
      '13333313',
      NULL,
      '04213312',
      NULL,
      '43330203',
      '42102331',
      '12030002',
      '42443043',
      '31430324',
      '21013234',
      '03231441',
      NULL,
      '22343441',
      '23410412',
      '23402120',
      '44001223',
      '32340430',
      '24443443',
      '20042234',
      '23444243',
      '01214022',
      '11241222',
      NULL,
      '34042031',
      '40242123',
      '24102412',
      '42312204',
      '30430201',
      '12330440',
      '34314110',
      '24004214',
      '12000310',
      '14131120',
      '431',
      '34',
      NULL,
      NULL,
      '2122410',
      1.131406,
      1.937662,
      3,
      NULL,
      '133042',
      5.709145,
      ' 5- 9-1998',
      ' 0-27-1999',
      NULL,
      NULL,
      27,
      29,
      30,
      14,
      23,
      22.390051,
      NULL,
      12.008154,
      19.955708,
      6,
      35,
      27,
      30.959253,
      1.383715,
      16.575617,
      3.492861,
      7.709603,
      12.157800,
      31.282257,
      NULL,
      109.349488,
      17,
      NULL,
      NULL,
      197,
      NULL,
      78.149425,
      106,
      NULL,
      ' 1-18-1996',
      NULL,
      38.067892,
      13,
      2,
      40.075285,
      NULL,
      '10-22-1997',
      1,
      NULL,
      1.057361,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1.603705,
      1.363844,
      1.094064,
      1.206805,
      0,
      0.686307,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-10-2002',
      73,
      21.456682,
      1.937879,
      1,
      2.023797,
      6,
      ' 3-26-2002',
      1,
      0,
      205,
      0,
      3.369925,
      166.881560,
      1.022528,
      1.436695,
      64,
      0,
      0.432741,
      106,
      '11-28-1980',
      20.219535,
      38,
      NULL,
      96,
      39,
      36,
      70.408465,
      42,
      60,
      NULL,
      NULL,
      13.553201,
      ' 9- 3-1994',
      NULL,
      9,
      1.605223,
      NULL,
      NULL,
      121.468238,
      6,
      ' 5- 0-1992',
      11.876362,
      11,
      ' 6- 3-1989',
      9.707249,
      6.113020,
      28,
      NULL,
      NULL,
      NULL,
      0,
      22,
      1.618027,
      107.103669,
      NULL,
      2,
      10,
      5,
      0,
      0,
      0.397494,
      NULL,
      ' 7-25-1993',
      0,
      5.278068,
      9,
      ' 4- 2-2000',
      NULL,
      4,
      ' 6-17-1999',
      56,
      4.440470,
      NULL,
      9.773737,
      NULL,
      9.602646,
      ' 5-20-2001',
      4.943590,
      NULL,
      ' 6- 6-1986',
      6.110981,
      97,
      ' 3- 5-2003',
      NULL,
      5.957662,
      ' 3-14-2003',
      NULL,
      6,
      ' 0-21-2000',
      0,
      NULL,
      7.232952,
      NULL,
      NULL,
      NULL,
      15,
      ' 3-22-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10);
commit;
end;
/


