set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7812239';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0001',
      '04241321',
      '21210202',
      '12241304',
      '02441143',
      '01421340',
      NULL,
      '31413411',
      '44020400',
      '41001211',
      '42224114',
      NULL,
      NULL,
      NULL,
      '22420312',
      '21430220',
      NULL,
      '44344243',
      NULL,
      '33233043',
      '40130202',
      '30044431',
      NULL,
      NULL,
      '23310313',
      '13134414',
      '30320041',
      '22221432',
      '11010004',
      '21244242',
      NULL,
      '40142141',
      '42201403',
      '34044323',
      '12034204',
      '20432202',
      NULL,
      '31223020',
      '11203011',
      '41240311',
      NULL,
      '34004211',
      '12344130',
      '43401134',
      '14310131',
      '202',
      '13',
      14.427294,
      9,
      NULL,
      1.612680,
      NULL,
      3,
      NULL,
      '114140',
      4.815270,
      ' 1- 8-1986',
      ' 9- 6-1984',
      NULL,
      NULL,
      26.091357,
      5,
      8.633172,
      12,
      12,
      19,
      NULL,
      4,
      NULL,
      0.814971,
      0.297320,
      NULL,
      22,
      4.551211,
      2,
      4.256045,
      NULL,
      NULL,
      36.712951,
      19,
      NULL,
      3,
      1,
      61,
      154,
      84,
      NULL,
      152,
      NULL,
      NULL,
      10,
      NULL,
      22,
      7.199390,
      75,
      153.317586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.357315,
      NULL,
      14.199001,
      7,
      5,
      '11- 7-1980',
      0.610809,
      NULL,
      51.445993,
      0,
      0.569832,
      17,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      ' 1-27-1976',
      NULL,
      10,
      NULL,
      20.549449,
      31,
      101.211472,
      21,
      NULL,
      32,
      NULL,
      30.267836,
      82.095377,
      NULL,
      3.143305,
      4,
      6,
      21.915444,
      6.565485,
      1,
      NULL,
      ' 0- 6-1976',
      NULL,
      1.047102,
      NULL,
      1.670765,
      1,
      9.926208,
      1.259412,
      7.890863,
      NULL,
      1.719860,
      6,
      NULL,
      48,
      0,
      2,
      10.679302,
      1.541642,
      1.145608,
      11.166861,
      11.672762,
      NULL,
      ' 3-16-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      138,
      16.587107,
      ' 2-26-1975',
      NULL,
      NULL,
      NULL,
      14.107003,
      ' 8-26-1994',
      27.689789,
      ' 8-25-1991',
      13,
      4.232353,
      ' 8-26-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      4.399332,
      ' 6-15-1977',
      NULL,
      55.287118,
      50.491387,
      ' 3-13-1977',
      1,
      NULL,
      ' 9-29-1985',
      8,
      149,
      3.292400,
      181.980566,
      ' 6- 2-1989',
      NULL,
      0,
      NULL,
      ' 0-17-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


