set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7812239';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1421',
      '00121103',
      NULL,
      '22430414',
      '34221213',
      '34444003',
      NULL,
      '42313203',
      '31033211',
      '43241401',
      NULL,
      '44111121',
      '31314042',
      '14101210',
      NULL,
      NULL,
      '11442044',
      NULL,
      '21200234',
      '12002310',
      NULL,
      '03031403',
      '30300414',
      NULL,
      '40130124',
      '41441022',
      '01210013',
      '44131244',
      '41123410',
      '23430201',
      '23231230',
      '40322404',
      '43300341',
      '41224214',
      '33330030',
      '14402232',
      '01442211',
      '14030130',
      '24342001',
      '32412421',
      NULL,
      '44320021',
      '12304011',
      NULL,
      NULL,
      '012',
      NULL,
      2,
      9,
      '1443214',
      1.096588,
      NULL,
      NULL,
      NULL,
      '403012',
      0,
      NULL,
      '10- 6-1983',
      NULL,
      63.981242,
      17.201058,
      NULL,
      6,
      2,
      67.194169,
      11.131970,
      NULL,
      1.925064,
      36.952779,
      13,
      NULL,
      11.327408,
      22,
      4.831410,
      10,
      11.753812,
      NULL,
      6,
      NULL,
      NULL,
      38,
      4.216279,
      0.575436,
      11,
      20.068042,
      36.298780,
      102,
      NULL,
      48.050382,
      ' 5-20-1977',
      38,
      16.650400,
      32,
      26,
      153,
      NULL,
      '10-21-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33.543298,
      36,
      15.448301,
      11.750103,
      16.564298,
      1.231031,
      ' 3-13-1982',
      NULL,
      0,
      NULL,
      0,
      1.078609,
      28.956436,
      1.996001,
      NULL,
      44,
      NULL,
      NULL,
      NULL,
      '10- 0-1988',
      56,
      6.282103,
      71,
      51,
      56,
      NULL,
      44.277600,
      11,
      54,
      86,
      0,
      45,
      ' 2- 8-1983',
      NULL,
      5,
      5,
      73.695217,
      16.970761,
      76.240640,
      3,
      ' 9-21-1980',
      6,
      5.096650,
      NULL,
      6,
      NULL,
      9.911495,
      NULL,
      2,
      NULL,
      0,
      18.420291,
      NULL,
      33,
      0,
      NULL,
      NULL,
      NULL,
      4.694864,
      NULL,
      3,
      3.678322,
      ' 2-16-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      107.955822,
      0,
      ' 4- 8-1979',
      NULL,
      NULL,
      NULL,
      34,
      '11- 6-1996',
      0.581578,
      NULL,
      4,
      13.129975,
      '11-29-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      10.449211,
      ' 9- 2-1991',
      66,
      6.556167,
      45.189247,
      ' 8-26-1983',
      1.865923,
      146.218375,
      ' 0- 7-1986',
      4.867587,
      NULL,
      6,
      NULL,
      ' 3- 6-2001',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


