set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9200739';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '3',
      '3',
      '2',
      '0',
      '3',
      NULL,
      '3',
      '2',
      '1',
      '3',
      '0',
      '3',
      '4',
      '4',
      '4',
      NULL,
      '1',
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '',
      '1',
      '',
      '3',
      '0',
      NULL,
      '0',
      NULL,
      '',
      '',
      '0',
      '0',
      '4',
      '4',
      '0',
      '0',
      NULL,
      '2',
      NULL,
      '2',
      '0',
      '233',
      '40400432',
      50.472590,
      14.623443,
      '4214242',
      0.535042,
      1,
      2,
      NULL,
      NULL,
      2,
      NULL,
      ' 8-11-2003',
      204.077191,
      56,
      5.550402,
      20,
      25.284002,
      NULL,
      55.671010,
      11.903587,
      23,
      21,
      7.524433,
      11,
      36.932566,
      21,
      9.710032,
      13,
      23.499017,
      9,
      NULL,
      NULL,
      NULL,
      21.516905,
      113,
      NULL,
      0,
      5.468362,
      NULL,
      39,
      NULL,
      3.852660,
      114.745294,
      ' 9- 9-1974',
      60,
      65,
      31,
      NULL,
      NULL,
      101,
      ' 2- 6-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.160938,
      5.156132,
      NULL,
      20.885293,
      NULL,
      ' 6-18-1974',
      1.185603,
      0.354040,
      246.381200,
      2.025462,
      NULL,
      111.002269,
      1.254570,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      96.760431,
      41,
      69.864158,
      48,
      NULL,
      6,
      86.383469,
      62,
      56.597675,
      69.859207,
      8.170162,
      83.445057,
      ' 8- 1-1977',
      20,
      25.680303,
      18,
      85,
      87,
      NULL,
      4,
      ' 4-28-2003',
      33.563853,
      16,
      ' 4- 5-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.686787,
      ' 9-20-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 0-1981',
      NULL,
      '10-14-1976',
      NULL,
      NULL,
      ' 8- 7-2000',
      2.803274,
      135,
      ' 5-15-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      14,
      ' 1-19-1993',
      21.912809,
      28.973399,
      55,
      ' 2- 7-1974',
      0,
      6.153968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


