set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025572';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4130',
      '32341010',
      '22230444',
      '33444311',
      '10013410',
      '01110030',
      '13032340',
      NULL,
      '00233303',
      NULL,
      '14342131',
      '03222343',
      '43020303',
      '41304101',
      NULL,
      '33011201',
      NULL,
      '33212314',
      '13223200',
      '40113032',
      '03124104',
      '13141123',
      NULL,
      NULL,
      '30021013',
      NULL,
      '32433240',
      NULL,
      NULL,
      NULL,
      NULL,
      '10113043',
      '41434012',
      NULL,
      '14022413',
      '04302144',
      '31403233',
      '21322420',
      '33111134',
      '03034431',
      '40442023',
      '42231020',
      '01234421',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '4133121',
      0,
      0.239210,
      1,
      NULL,
      '432002',
      0,
      '11-19-1982',
      ' 6- 9-1980',
      74.356329,
      NULL,
      34,
      16.262464,
      NULL,
      12,
      22.204681,
      1.242983,
      25.198339,
      23,
      18,
      21.446904,
      NULL,
      25,
      23.765661,
      12,
      18.738036,
      NULL,
      44,
      15.803761,
      30,
      NULL,
      77.751210,
      9.595031,
      NULL,
      21.428542,
      NULL,
      13,
      22.661182,
      46,
      144,
      ' 1-11-2002',
      6,
      3,
      26.212068,
      32.894644,
      105.460157,
      55.387473,
      NULL,
      2.781424,
      0.528568,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.366308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-15-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-25-1978',
      93,
      NULL,
      88.971621,
      26,
      26,
      80.585565,
      NULL,
      106.751753,
      104.179820,
      17,
      11,
      NULL,
      ' 9-27-1993',
      25.161929,
      NULL,
      6.778420,
      NULL,
      NULL,
      32.785553,
      7,
      ' 2-13-2001',
      19,
      3.137800,
      ' 3- 5-1993',
      10,
      3.820435,
      14.161300,
      25,
      17.459595,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      1,
      15.185474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-14-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      56.235512,
      30.819327,
      21.325057,
      ' 5-12-1986',
      0,
      35.685504,
      ' 5- 8-1988',
      8.457318,
      12.287618,
      NULL,
      0,
      NULL,
      11,
      NULL,
      NULL,
      ' 7-14-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      0.530154,
      1.245872,
      NULL,
      NULL,
      120.058848,
      87,
      9.572331,
      58,
      51.971492,
      0,
      NULL,
      1.627819,
      1,
      103.068131,
      1.398899,
      3,
      42,
      1.648191,
      NULL,
      NULL,
      0.197021,
      1,
      107,
      NULL,
      9.798428,
      NULL,
      0,
      NULL,
      0.798571,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      5.193814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.417603,
      NULL,
      0,
      0,
      NULL,
      1.762038,
      11,
      3,
      NULL,
      NULL,
      14.073430,
      NULL,
      9.711783,
      NULL,
      1.620654,
      0.325350,
      0.968653,
      1,
      1.969569,
      1,
      NULL,
      '11- 5-1991',
      ' 3-10-1995',
      ' 8- 1-1986',
      NULL,
      ' 5-21-1983',
      '10-18-2002',
      NULL,
      NULL);
commit;
end;
/


