set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9858589';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      NULL,
      NULL,
      '1',
      '4',
      '4',
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      '4',
      '4',
      '2',
      '0',
      NULL,
      '0',
      '1',
      '2',
      '4',
      NULL,
      '3',
      '0',
      '',
      '2',
      '',
      '1',
      '0',
      '1',
      NULL,
      '0',
      '',
      '',
      '2',
      '1',
      '2',
      '2',
      '3',
      '0',
      '3',
      '4',
      '3',
      '1',
      '2',
      '201',
      NULL,
      7,
      7.561046,
      '3220223',
      NULL,
      47,
      0,
      1,
      '301344',
      1,
      '11-20-1990',
      ' 8- 7-1981',
      10.378463,
      40.208040,
      NULL,
      12,
      17.604942,
      0,
      NULL,
      16.072486,
      0.121509,
      1.000853,
      17.075659,
      NULL,
      NULL,
      NULL,
      NULL,
      7.652195,
      NULL,
      12,
      55.383947,
      12,
      44.770181,
      0,
      NULL,
      12.170985,
      0,
      94.261067,
      113.924820,
      11,
      110.775560,
      152.945213,
      17.294783,
      ' 6- 7-1979',
      35,
      NULL,
      35,
      NULL,
      143,
      51,
      ' 7- 9-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.013709,
      NULL,
      NULL,
      3,
      1,
      ' 1-13-1983',
      3.331876,
      2.024812,
      NULL,
      0,
      1.839377,
      99.397605,
      0,
      NULL,
      43.322498,
      NULL,
      NULL,
      NULL,
      ' 7-26-1985',
      NULL,
      NULL,
      86,
      30.459159,
      39.955087,
      44.259525,
      NULL,
      42.596824,
      NULL,
      3.899196,
      31,
      16.540337,
      ' 4-13-2002',
      10,
      NULL,
      26,
      34.260559,
      79.847084,
      22.116241,
      NULL,
      ' 7- 1-1989',
      16,
      14.783124,
      ' 0-19-1985',
      14.942815,
      6,
      9.269856,
      6.725696,
      15.272592,
      1.204163,
      1.945849,
      14,
      0,
      54,
      1.517804,
      1.507801,
      7,
      0,
      3.492872,
      1,
      1.417145,
      0.754829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37.410181,
      4.463360,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      ' 1- 4-1997',
      NULL,
      NULL,
      20.695545,
      4.750242,
      ' 7-26-1982',
      107,
      73.869810,
      ' 1-21-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      10,
      ' 5-10-1976',
      31.167198,
      3.428212,
      19,
      NULL,
      0,
      121,
      ' 5-12-1987',
      2,
      22.976224,
      2.918823,
      5,
      NULL,
      36,
      1,
      36,
      '11-27-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


