set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9333174';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3140',
      '21101232',
      '12122140',
      '41313200',
      '43143142',
      '42341312',
      '01310111',
      '43204432',
      '00134210',
      '31300012',
      '14044440',
      '30144112',
      NULL,
      NULL,
      '43231020',
      '33112143',
      '32220203',
      '33431200',
      '12140223',
      '40014313',
      '02330340',
      '34340022',
      '32013041',
      '23002430',
      '22101102',
      '12422132',
      '20000114',
      '30124232',
      '04422310',
      '31022133',
      '20214041',
      '10124133',
      '21224342',
      '32023124',
      '01240240',
      '30232424',
      '10041041',
      '10024233',
      '10340142',
      '01044143',
      '02314343',
      '43031310',
      '21412424',
      '22432114',
      '34113032',
      '302',
      NULL,
      NULL,
      NULL,
      '4434003',
      0,
      1.997256,
      1,
      NULL,
      '222332',
      1,
      '10-23-1981',
      NULL,
      76.175761,
      NULL,
      15,
      3.414631,
      NULL,
      15.054515,
      30,
      10.582675,
      NULL,
      0.654848,
      23.863022,
      2,
      NULL,
      8.312552,
      23,
      0,
      NULL,
      1.292700,
      56.930361,
      NULL,
      NULL,
      2,
      NULL,
      17,
      0,
      121,
      7,
      52.655234,
      58.288498,
      199.578265,
      138.836932,
      ' 2- 2-1995',
      NULL,
      NULL,
      15.709155,
      33,
      12,
      45.787979,
      ' 1-18-1974',
      0.965621,
      11,
      NULL,
      2.916748,
      0,
      4,
      0.675684,
      NULL,
      NULL,
      0,
      2,
      1.204563,
      0.773014,
      6,
      1,
      1.858785,
      6.195943,
      1,
      0.422544,
      0.579788,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-18-2000',
      68.372453,
      NULL,
      9.900590,
      NULL,
      6.740947,
      6,
      ' 6- 5-1981',
      0,
      1,
      69,
      0,
      3.102843,
      149.712604,
      NULL,
      0,
      49,
      NULL,
      NULL,
      NULL,
      '10- 3-1997',
      53.820300,
      19,
      87,
      74,
      NULL,
      NULL,
      62.550052,
      90.446239,
      67,
      75.556460,
      3,
      32,
      ' 2-25-1986',
      5,
      17.611069,
      NULL,
      17.571490,
      54.203654,
      57.902069,
      6.445203,
      ' 7-26-1977',
      12,
      4,
      ' 6- 9-1977',
      NULL,
      5.595787,
      4,
      13,
      14,
      7,
      0,
      14,
      0.774558,
      73.371597,
      1,
      2,
      5,
      NULL,
      NULL,
      15,
      0.583815,
      NULL,
      ' 8-10-2003',
      3.785873,
      2,
      0.135125,
      ' 2-25-1996',
      NULL,
      1,
      ' 1- 3-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 6-1986',
      24,
      '11-14-1974',
      8,
      NULL,
      ' 3- 9-1991',
      37,
      123,
      '10- 0-1987',
      10,
      2,
      ' 9- 9-1991',
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      '10-20-1991',
      24,
      24,
      4,
      NULL,
      0,
      19.378557,
      ' 3-24-1975',
      12.930743,
      NULL,
      11.509186,
      NULL,
      ' 8-18-1996',
      39.033019,
      1.029126,
      186.709183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.288926);
commit;
end;
/


