set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9333174';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1431',
      NULL,
      NULL,
      '22001003',
      '12202324',
      '02032233',
      NULL,
      '30142410',
      '34400013',
      NULL,
      NULL,
      '41234214',
      '11032422',
      '41402404',
      '00114104',
      '10121410',
      '11403414',
      '12042311',
      NULL,
      '40134140',
      '23421233',
      NULL,
      NULL,
      NULL,
      '04223112',
      '34423134',
      '41222141',
      NULL,
      '44334344',
      '23441344',
      '14141212',
      '01433242',
      NULL,
      NULL,
      '32001404',
      '13032111',
      NULL,
      '14142304',
      '24032411',
      '44043232',
      '42402034',
      '02140300',
      '23022414',
      '22304233',
      '43244431',
      '034',
      '02',
      NULL,
      NULL,
      '0230031',
      2,
      NULL,
      0,
      NULL,
      '334044',
      5.643269,
      ' 2- 7-1987',
      ' 0-24-1991',
      64,
      NULL,
      NULL,
      2.993834,
      9.709968,
      0.314051,
      NULL,
      12.514329,
      30.109841,
      1.719663,
      39,
      NULL,
      32,
      5.598832,
      7.573541,
      7,
      NULL,
      12.643860,
      47,
      8,
      6.013724,
      10,
      73.914481,
      15,
      1.982412,
      NULL,
      4,
      5.565805,
      68,
      119.556752,
      NULL,
      ' 7-16-1988',
      11,
      30,
      19.197371,
      4.770561,
      78.888312,
      7.742258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20.365857,
      8,
      0.827501,
      12.970813,
      NULL,
      ' 5- 6-2002',
      1.978020,
      0,
      99.063982,
      0.533984,
      1,
      67.828543,
      NULL,
      0,
      79,
      NULL,
      NULL,
      NULL,
      ' 0- 3-1974',
      NULL,
      44,
      41,
      70.396947,
      NULL,
      NULL,
      103,
      68,
      NULL,
      74,
      57.296296,
      NULL,
      ' 8-14-1978',
      NULL,
      9,
      15.553776,
      45.175469,
      50,
      50.817291,
      4.139069,
      ' 0- 4-1987',
      12.886886,
      8,
      ' 6-14-2002',
      NULL,
      12,
      13,
      NULL,
      24,
      NULL,
      NULL,
      17.764157,
      0.763000,
      98,
      NULL,
      0,
      5.659728,
      2,
      NULL,
      NULL,
      2,
      0.152902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38.178191,
      0,
      '10- 5-2000',
      NULL,
      NULL,
      NULL,
      36.873922,
      ' 4-15-1981',
      4,
      NULL,
      0.473537,
      9.501737,
      ' 4-15-1991',
      71,
      22.726366,
      ' 6- 7-1974',
      1,
      1,
      '11-29-1981',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      19,
      ' 8-18-1997',
      22,
      NULL,
      22,
      ' 5-19-1990',
      NULL,
      41.645310,
      NULL,
      9.872782,
      19.812121,
      0,
      25.749737,
      ' 3-26-1991',
      46.943901,
      NULL,
      11,
      ' 1-22-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


