set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9333174';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1031',
      '10341142',
      '43142022',
      '41002221',
      '21314103',
      '12311001',
      '44114012',
      '33140402',
      '23142010',
      NULL,
      '10032211',
      '02230422',
      '21314201',
      '13022011',
      '42013440',
      NULL,
      '41142020',
      NULL,
      '11302332',
      NULL,
      '04404412',
      '02043140',
      '12023443',
      '34433223',
      NULL,
      '14222040',
      '31403211',
      '10442221',
      '41403434',
      '24041124',
      '01413312',
      NULL,
      '11022002',
      '30411203',
      NULL,
      '24232032',
      NULL,
      '31322030',
      '20224243',
      NULL,
      NULL,
      NULL,
      NULL,
      '11242023',
      NULL,
      '142',
      NULL,
      NULL,
      NULL,
      '0313112',
      3.807516,
      66,
      0,
      NULL,
      '344302',
      2,
      '11-29-1999',
      ' 8-19-1982',
      46,
      134,
      34.779870,
      7.162700,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      13,
      40.214992,
      21.786724,
      14.115635,
      12.999944,
      22,
      6.775680,
      18,
      11,
      34,
      20,
      25,
      6.107695,
      NULL,
      18,
      NULL,
      116.546698,
      NULL,
      3,
      NULL,
      96.059829,
      NULL,
      ' 2-13-1989',
      NULL,
      41.302375,
      30,
      20,
      100,
      122.485522,
      ' 9- 2-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      1.866971,
      5.693845,
      NULL,
      NULL,
      1.721257,
      NULL,
      NULL,
      NULL,
      NULL,
      119.823270,
      1,
      0.005003,
      32.762498,
      NULL,
      NULL,
      NULL,
      ' 1- 6-1980',
      93,
      17,
      94,
      NULL,
      60,
      NULL,
      12,
      81,
      22,
      29.726787,
      84,
      12,
      ' 6-18-1986',
      4,
      10.350260,
      1.659182,
      13,
      26.118056,
      13.640531,
      4,
      ' 0-12-1988',
      32.523387,
      29,
      NULL,
      2,
      13.743074,
      2.187196,
      4,
      17,
      2.708136,
      0,
      7,
      0,
      13,
      1.165584,
      1,
      11,
      NULL,
      NULL,
      5,
      0,
      1.888407,
      ' 5- 1-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 2-1986',
      NULL,
      NULL,
      NULL,
      28.606865,
      ' 7- 3-1990',
      19.323258,
      ' 9-28-1981',
      4,
      2,
      ' 7-29-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2.745097,
      ' 9-16-1991',
      NULL,
      12,
      NULL,
      ' 9-14-1995',
      1.364879,
      103.368519,
      ' 8-29-1974',
      2.922791,
      52,
      20,
      30,
      ' 1- 2-2000',
      7.907093,
      1,
      85,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


