set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9333174';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '4',
      NULL,
      '4',
      '1',
      '0',
      '2',
      '2',
      '0',
      NULL,
      '2',
      '2',
      '0',
      '2',
      NULL,
      '0',
      '1',
      '1',
      '3',
      NULL,
      '2',
      '4',
      '4',
      '',
      NULL,
      '',
      '4',
      NULL,
      '2',
      '2',
      '1',
      '',
      '',
      '4',
      '1',
      '0',
      '3',
      '0',
      '1',
      '0',
      '3',
      '3',
      '2',
      '3',
      '112',
      NULL,
      45.099632,
      7,
      '0101323',
      2,
      119,
      2,
      1,
      '103033',
      3,
      ' 8-20-1987',
      ' 4-12-1976',
      21.436706,
      132,
      37.037789,
      0.348687,
      19,
      18.529028,
      70.316844,
      19.666597,
      26.075549,
      NULL,
      20.847863,
      5,
      26.042542,
      22,
      12.651380,
      8,
      0,
      5.752166,
      32.890793,
      9,
      47,
      10.675202,
      72,
      17.753460,
      1.874827,
      88,
      NULL,
      79,
      74,
      206,
      69.888171,
      ' 9-15-1998',
      24.575870,
      20.775077,
      35.298967,
      11,
      169,
      NULL,
      ' 0-25-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      97.981923,
      NULL,
      2,
      6.578297,
      9,
      0,
      ' 6- 8-1975',
      0,
      NULL,
      231,
      0,
      1.810478,
      76,
      1,
      1.934724,
      84.278256,
      NULL,
      NULL,
      NULL,
      ' 8-29-1994',
      53.799565,
      52,
      68.339505,
      5,
      71,
      54,
      110,
      50.887394,
      48.997991,
      8.366982,
      89.970034,
      NULL,
      ' 8-22-1978',
      3.041410,
      19.300177,
      24.544727,
      35,
      57.007787,
      5,
      9,
      ' 0-22-1982',
      8.079707,
      1.020338,
      NULL,
      NULL,
      10.329724,
      NULL,
      5,
      9,
      7.816547,
      1.607980,
      3,
      NULL,
      9,
      0.197082,
      1.046097,
      5,
      29,
      1.257631,
      0,
      0.250244,
      1.065480,
      ' 6-16-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      223,
      10.353255,
      ' 4-28-1979',
      NULL,
      NULL,
      NULL,
      59.505777,
      ' 4-19-1975',
      7,
      ' 4-22-1980',
      4,
      0,
      NULL,
      49.048525,
      115,
      ' 8- 4-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      42,
      1,
      24,
      NULL,
      0,
      NULL,
      ' 2-29-1999',
      7,
      34.867503,
      16.873257,
      2,
      ' 6- 9-2001',
      52,
      0,
      48,
      '11-15-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


