set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9307171';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4301',
      '24441242',
      '02203033',
      '02420320',
      '11103320',
      '02442311',
      '30123414',
      '42414212',
      '44013124',
      '43240443',
      NULL,
      '10124231',
      '02343011',
      '33042234',
      '03103201',
      '23201141',
      '14303431',
      '00244434',
      NULL,
      '23224200',
      '13221312',
      NULL,
      '21330030',
      '43214420',
      '32310121',
      '12104331',
      '24044413',
      '21043002',
      '34113434',
      '00331411',
      NULL,
      '12134404',
      NULL,
      '42113211',
      '43011141',
      '21410104',
      NULL,
      NULL,
      '04042203',
      '24242304',
      '24441012',
      '42334311',
      '20123022',
      '01000223',
      NULL,
      '243',
      '42',
      NULL,
      NULL,
      '3242301',
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      ' 9-11-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      6.839399,
      18.742181,
      13.744179,
      58.895613,
      5.788691,
      20,
      19,
      38,
      12,
      32,
      2,
      39,
      11,
      18,
      12,
      NULL,
      11,
      54.078059,
      21.272598,
      NULL,
      NULL,
      0.977882,
      83,
      65,
      110.501757,
      230,
      77,
      NULL,
      ' 4- 9-1978',
      23.063439,
      44.547512,
      27.231612,
      29,
      186.266989,
      NULL,
      ' 6-26-1998',
      0,
      0.855466,
      0.998840,
      2.028629,
      1,
      NULL,
      NULL,
      NULL,
      0.221571,
      1.566455,
      1,
      NULL,
      1.864826,
      1.685328,
      0,
      0.510269,
      1.099421,
      NULL,
      0.809550,
      0.367704,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-18-2002',
      24,
      9,
      12.088808,
      12,
      12,
      6.109732,
      '11- 7-1975',
      1,
      1,
      NULL,
      1,
      0,
      23.238306,
      1.524388,
      2.264416,
      57,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      110,
      NULL,
      29,
      109,
      87,
      75,
      34,
      71.032142,
      47.994879,
      17,
      ' 4-29-2002',
      3.674278,
      5.492879,
      15.750816,
      NULL,
      NULL,
      71.521690,
      4.146083,
      ' 8- 4-1975',
      8.351764,
      NULL,
      ' 2-12-2000',
      NULL,
      1,
      19,
      17.798624,
      NULL,
      10.599515,
      1,
      5.891106,
      NULL,
      26,
      1.494284,
      NULL,
      2,
      26,
      1.129528,
      1.660893,
      0.151659,
      0,
      ' 3-10-2003',
      7.134065,
      0.554667,
      3.659120,
      ' 7- 9-2000',
      19.185276,
      19,
      '10-25-1974',
      NULL,
      NULL,
      NULL,
      32.615797,
      '11- 4-1981',
      NULL,
      ' 7-25-2002',
      5,
      1.420063,
      ' 3-27-1997',
      33.465420,
      120.716205,
      ' 5-24-1977',
      0.393719,
      2.419103,
      ' 5-18-1988',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      ' 2-18-1983',
      NULL,
      NULL,
      2.565418,
      ' 7-12-1977',
      NULL,
      NULL,
      ' 5- 5-1990',
      NULL,
      28.028038,
      4,
      20,
      '10- 6-1974',
      48,
      1.772754,
      68.619476,
      ' 1-25-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.662938);
commit;
end;
/


