set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303656';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1131',
      '22323242',
      '22120301',
      NULL,
      '20323430',
      '11012322',
      '10300440',
      NULL,
      '41221310',
      NULL,
      '30242302',
      '40311320',
      '21143201',
      '13330113',
      '32013000',
      '22143210',
      '02111120',
      NULL,
      '13342424',
      '14232313',
      '00414122',
      '12102121',
      '21240421',
      NULL,
      '34321241',
      '24440042',
      '00010210',
      '32140121',
      NULL,
      '33141020',
      '10432122',
      '02440133',
      '21410314',
      '11441032',
      '30004132',
      NULL,
      '00042130',
      '41410014',
      '33123134',
      NULL,
      NULL,
      '10441041',
      '32044143',
      '33011300',
      '13113400',
      '011',
      NULL,
      NULL,
      NULL,
      '0400131',
      0,
      NULL,
      0,
      NULL,
      '231410',
      4.688500,
      '11-29-1997',
      '11-16-1988',
      99,
      NULL,
      22.968934,
      10,
      19,
      10.890685,
      59,
      7.453157,
      5,
      NULL,
      17,
      NULL,
      17,
      16,
      13.689082,
      9,
      9,
      3,
      32.194843,
      20,
      4,
      NULL,
      NULL,
      14.697284,
      0,
      NULL,
      122,
      NULL,
      NULL,
      38.618811,
      41,
      ' 1-25-1991',
      2,
      20.221302,
      19.014500,
      NULL,
      31.900325,
      64,
      ' 7- 6-1977',
      1.610832,
      1,
      NULL,
      7,
      1.951421,
      16.950108,
      0.672994,
      20,
      0,
      NULL,
      2,
      2.723737,
      1.117170,
      1.826376,
      1.181711,
      0.686721,
      29,
      0.407447,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      51.211610,
      32.757990,
      0,
      NULL,
      2,
      ' 8- 8-1993',
      0,
      3,
      27,
      0,
      4.495269,
      NULL,
      4.054274,
      1,
      69,
      NULL,
      NULL,
      NULL,
      '11-27-1999',
      NULL,
      60.279905,
      46,
      33,
      36.260502,
      72,
      63,
      49.037547,
      3.063826,
      26,
      12,
      NULL,
      ' 9-21-1974',
      19.133032,
      10.626815,
      7.236259,
      10,
      41,
      15,
      9.254637,
      NULL,
      NULL,
      24.752686,
      ' 3- 7-1988',
      7.804741,
      12.647981,
      7,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      38.965264,
      0.604997,
      0.672375,
      17.741498,
      15.611518,
      1.714895,
      1.701034,
      1,
      0.628831,
      ' 2-28-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      164.527541,
      5,
      ' 9- 4-1980',
      NULL,
      NULL,
      NULL,
      41,
      ' 1- 9-1980',
      NULL,
      NULL,
      10.584695,
      NULL,
      ' 0-24-1992',
      56,
      16.812519,
      ' 1-27-1986',
      4,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      ' 1-16-1989',
      54,
      67,
      11.633570,
      '10- 3-2000',
      0.418120,
      165.831592,
      NULL,
      9,
      NULL,
      NULL,
      59.588266,
      '11-15-1982',
      66,
      1,
      22,
      ' 2-15-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


