set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9768014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      '2',
      '0',
      '3',
      '2',
      '0',
      '2',
      '0',
      '3',
      '0',
      '2',
      '3',
      '1',
      NULL,
      '4',
      NULL,
      '4',
      '3',
      '1',
      '3',
      '3',
      '2',
      NULL,
      '',
      '2',
      '',
      '2',
      '4',
      NULL,
      '4',
      '4',
      '',
      '',
      '1',
      '1',
      '3',
      '2',
      '4',
      '2',
      '2',
      '4',
      NULL,
      '2',
      NULL,
      '411',
      '02303304',
      43,
      36.383159,
      '4210112',
      2.081554,
      0.324231,
      0,
      NULL,
      '321410',
      NULL,
      NULL,
      ' 4- 8-1988',
      NULL,
      NULL,
      10.114434,
      NULL,
      21,
      17.527923,
      NULL,
      23,
      13,
      2,
      23,
      5,
      1,
      9,
      14,
      3.145745,
      1.596331,
      23,
      62,
      20,
      20,
      NULL,
      109.486433,
      2,
      1.106077,
      NULL,
      74,
      107.514286,
      99.013497,
      NULL,
      NULL,
      '11-26-2001',
      43,
      28.643481,
      NULL,
      9,
      131.795129,
      159,
      ' 8- 0-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.591533,
      16.836729,
      23,
      16,
      0,
      ' 8- 6-1993',
      NULL,
      NULL,
      167.283108,
      1.732757,
      NULL,
      43,
      NULL,
      0.096572,
      18,
      NULL,
      NULL,
      NULL,
      '10-24-1975',
      36.733757,
      49,
      10.203728,
      39,
      NULL,
      55.060480,
      25,
      67.912978,
      29.492851,
      32,
      14.247790,
      NULL,
      ' 7- 6-1997',
      6.945829,
      NULL,
      12,
      47,
      20.518660,
      93.071123,
      5.774041,
      NULL,
      32,
      19,
      ' 0- 5-1975',
      3,
      13,
      4,
      3.893018,
      NULL,
      0.756732,
      0.444803,
      10,
      1.344919,
      12.203584,
      1.945337,
      1,
      NULL,
      NULL,
      1.459180,
      NULL,
      0,
      1.965874,
      ' 8- 2-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      91,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.644225,
      ' 1-27-1987',
      44,
      ' 5-20-1997',
      NULL,
      12.544228,
      NULL,
      NULL,
      44,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      NULL,
      65.526428,
      2,
      19,
      NULL,
      2,
      136.996312,
      ' 6- 0-1974',
      NULL,
      40.833246,
      1.634789,
      3.843953,
      ' 2-17-2003',
      55,
      1.360530,
      94,
      ' 6-13-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


