set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9768014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '0',
      '0',
      NULL,
      '4',
      '2',
      '2',
      '2',
      '0',
      NULL,
      '0',
      '2',
      '1',
      '2',
      '4',
      '2',
      '3',
      '1',
      NULL,
      '4',
      NULL,
      '4',
      '1',
      '',
      '0',
      NULL,
      '4',
      '3',
      '0',
      '3',
      '4',
      '',
      '',
      NULL,
      '0',
      '0',
      '1',
      '2',
      '3',
      '4',
      '2',
      '4',
      '4',
      '4',
      '221',
      NULL,
      20,
      40,
      '1401244',
      3,
      12,
      0,
      NULL,
      '000341',
      2.297429,
      ' 4-20-1994',
      NULL,
      28,
      74,
      33,
      22.853456,
      NULL,
      0,
      70.300248,
      15.440697,
      13,
      NULL,
      24.427573,
      10.161388,
      23,
      8.787067,
      NULL,
      5.523460,
      10.423605,
      3,
      41.831081,
      23,
      58,
      20.087474,
      19,
      NULL,
      1.033591,
      114.504376,
      51,
      NULL,
      155.643988,
      27,
      197,
      ' 8-28-1982',
      11.095047,
      63,
      5,
      NULL,
      NULL,
      194,
      ' 4- 0-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      79.099723,
      27.170606,
      0.022756,
      10.212511,
      12,
      7,
      ' 8-28-1990',
      0.523734,
      0.099107,
      151,
      0,
      1,
      25.319958,
      0,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      ' 2- 2-1977',
      41.752693,
      70,
      54.724667,
      31.733023,
      105.845579,
      42.707791,
      27,
      30.065776,
      NULL,
      27.540995,
      4.268939,
      73,
      ' 0-11-1993',
      23,
      7.804787,
      NULL,
      74,
      75,
      NULL,
      10,
      ' 2-17-1997',
      9,
      17,
      ' 4-11-1981',
      8,
      4,
      3,
      12,
      13.038080,
      5.806256,
      1.101579,
      9,
      0,
      54,
      0,
      0.571723,
      6.215157,
      0,
      2,
      1,
      0,
      NULL,
      ' 1- 5-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      205.658288,
      5.437690,
      ' 1-23-1980',
      NULL,
      NULL,
      NULL,
      3.764407,
      ' 4- 9-1993',
      44,
      NULL,
      NULL,
      2.196974,
      ' 2- 1-1999',
      109.726936,
      110,
      ' 4-14-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      16,
      ' 7-26-1999',
      13,
      10.375020,
      6,
      ' 8- 6-1984',
      NULL,
      48.605244,
      ' 2-19-2003',
      NULL,
      15.131451,
      13,
      NULL,
      ' 1-24-1987',
      0,
      1,
      61.325295,
      ' 6- 5-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


