set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8426905';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0004',
      '20030413',
      '34113223',
      NULL,
      '10433412',
      '13240414',
      '11321333',
      '22103201',
      '22102414',
      '14130244',
      NULL,
      '03230303',
      NULL,
      '12023001',
      '13141312',
      '21131024',
      '12123122',
      '30034301',
      '14000343',
      '02414131',
      '10202112',
      '13423031',
      '44031113',
      '03113341',
      '42440433',
      '21103121',
      '23300333',
      '33422132',
      '41233310',
      '00113121',
      '41003301',
      '24002043',
      '01232404',
      '24114040',
      NULL,
      NULL,
      '24433020',
      '01203243',
      '12304322',
      '22024331',
      NULL,
      '12000121',
      '02231133',
      '41244242',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '2314331',
      NULL,
      0.639486,
      2,
      NULL,
      '324200',
      0.811145,
      NULL,
      NULL,
      39.789593,
      NULL,
      30,
      3,
      21.045316,
      6,
      79.361884,
      NULL,
      2.651954,
      NULL,
      36,
      NULL,
      NULL,
      13,
      11,
      16.843606,
      0,
      1,
      12,
      2,
      NULL,
      4,
      73.313610,
      2.667371,
      NULL,
      57,
      132,
      23,
      9,
      81,
      23.137188,
      '11-16-1982',
      64,
      2,
      20.262751,
      23.145714,
      80.206762,
      73.371479,
      ' 7-11-1987',
      NULL,
      4.227697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4.652239,
      0.867288,
      0.726435,
      1.045443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-17-1978',
      72,
      NULL,
      58,
      NULL,
      NULL,
      92.346856,
      34.945832,
      67,
      NULL,
      93,
      83,
      NULL,
      NULL,
      NULL,
      3.915078,
      NULL,
      28.202983,
      51.820542,
      24,
      NULL,
      ' 7- 7-1988',
      2,
      4,
      NULL,
      1.301603,
      12.364355,
      NULL,
      9.418562,
      9,
      9.529612,
      NULL,
      21,
      NULL,
      49,
      3.778787,
      6.406931,
      8.743145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 4-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      4,
      ' 7-28-1974',
      0,
      NULL,
      ' 3-22-1995',
      0.866839,
      129.651389,
      0.545227,
      55.267539,
      ' 7-25-1974',
      61,
      1,
      197,
      ' 8-13-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      41.497450,
      17,
      50,
      5,
      152,
      2.238055,
      NULL,
      2,
      35.141704,
      0.306769,
      NULL,
      0.284263,
      1,
      15.423954,
      0,
      0.012655,
      24,
      2.008925,
      0.463570,
      66.462361,
      0.978720,
      3,
      193,
      54.858956,
      NULL,
      4.239950,
      NULL,
      71,
      0.393755,
      1,
      1,
      1.272300,
      1,
      0.376511,
      43.193406,
      72.107014,
      17.058371,
      0,
      NULL,
      5.441382,
      1,
      1.591217,
      5.113586,
      0,
      NULL,
      1,
      6.578659,
      1,
      2.539114,
      5.993753,
      33,
      8.595798,
      1,
      5.393475,
      10,
      1.380353,
      NULL,
      44.464305,
      2,
      12,
      NULL,
      3.113986,
      11.794053,
      10,
      0.818697,
      NULL,
      1.772798,
      1,
      0,
      NULL,
      ' 3-13-1995',
      ' 5- 6-1998',
      ' 9-17-1986',
      ' 4-23-1994',
      NULL,
      '10-18-1998',
      ' 1-12-2003',
      NULL);
commit;
end;
/


