set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7825995';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4113',
      '33014122',
      '04400403',
      '00311330',
      '21212010',
      '22133103',
      '01234232',
      NULL,
      '04310331',
      '03243240',
      '32422401',
      '20331324',
      NULL,
      '00323003',
      NULL,
      '11213213',
      '22342432',
      '01114043',
      '13113234',
      '00022302',
      NULL,
      '11042432',
      '34100210',
      '31332203',
      '41221244',
      NULL,
      '30233124',
      '10324011',
      '30010300',
      NULL,
      '32012443',
      '22233443',
      '02113312',
      '00400234',
      '04141142',
      '10410111',
      '23134312',
      '10413241',
      '14021201',
      '13222431',
      '22123432',
      NULL,
      NULL,
      NULL,
      '22214200',
      '321',
      '14',
      13.408721,
      12.804867,
      '1221233',
      NULL,
      0.853128,
      2,
      NULL,
      '231210',
      3,
      ' 1- 9-1998',
      ' 3- 0-2003',
      28,
      NULL,
      34,
      14,
      16.756960,
      5,
      36,
      1.738843,
      2.144785,
      6,
      2.639713,
      7.530421,
      12.592510,
      5.950110,
      13.991979,
      5.484951,
      0,
      4,
      15.309503,
      2.590092,
      NULL,
      13,
      40,
      3.444057,
      0.850658,
      4.831144,
      NULL,
      44,
      111,
      8.475528,
      144,
      ' 6- 8-1996',
      7,
      21.131483,
      NULL,
      20,
      31,
      2.279373,
      ' 1-18-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170718,
      9,
      NULL,
      NULL,
      5.076204,
      ' 2-16-1985',
      0,
      1.552329,
      NULL,
      1,
      0,
      66,
      2.139524,
      NULL,
      0.325338,
      NULL,
      NULL,
      NULL,
      '11-15-1980',
      NULL,
      75.068239,
      NULL,
      29,
      40,
      42,
      41,
      91,
      3.489909,
      43.842761,
      NULL,
      16,
      ' 7-29-1993',
      0,
      NULL,
      4.424618,
      0,
      27.968219,
      5,
      0.373303,
      NULL,
      3.715020,
      11,
      ' 8-17-2003',
      3.932672,
      1,
      4.786458,
      0,
      4.343959,
      NULL,
      0,
      NULL,
      0.807329,
      15,
      7.551168,
      0,
      0,
      11.649849,
      4.434757,
      3,
      2,
      3.764585,
      ' 6-17-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      16.514417,
      0,
      '11-27-1979',
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      38.009249,
      ' 8-28-1995',
      0,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.774679,
      NULL,
      62.519736,
      NULL,
      12.043762,
      ' 0-18-2000',
      2.419134,
      198.874850,
      ' 7-28-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


