set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9933372';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      '2',
      '3',
      '4',
      '0',
      '3',
      '0',
      '0',
      '2',
      '1',
      '3',
      '4',
      '0',
      '0',
      NULL,
      '4',
      NULL,
      '4',
      '2',
      '0',
      '0',
      '3',
      '1',
      '',
      '2',
      '',
      NULL,
      '4',
      '4',
      NULL,
      '4',
      '',
      NULL,
      '2',
      '1',
      '4',
      '3',
      '2',
      '4',
      '2',
      NULL,
      '4',
      '0',
      '0',
      NULL,
      '21212012',
      38,
      46,
      NULL,
      2.654011,
      1.711708,
      3,
      0,
      '300402',
      5,
      ' 5-25-1984',
      ' 8-13-1990',
      1.269994,
      3.198824,
      5,
      0,
      6,
      NULL,
      24,
      3.729169,
      4,
      NULL,
      13.673988,
      3,
      1,
      NULL,
      4.238235,
      10.961725,
      13.576826,
      15,
      45,
      13,
      19,
      3.947782,
      42,
      NULL,
      0.385826,
      7.009320,
      NULL,
      64,
      NULL,
      51,
      92,
      ' 5-20-1990',
      NULL,
      4,
      9,
      12,
      117,
      78.838968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      47.357976,
      32.750919,
      9.459298,
      37.560219,
      5.318210,
      ' 9-22-1994',
      0,
      0,
      104,
      1.843894,
      0.955383,
      15.612424,
      NULL,
      0.107836,
      51,
      NULL,
      NULL,
      NULL,
      ' 0- 6-1998',
      25.099804,
      82,
      44.637257,
      7,
      3.055059,
      NULL,
      36.267102,
      30,
      71,
      20.810597,
      28,
      68,
      ' 4-16-1974',
      NULL,
      11.324334,
      NULL,
      10,
      14,
      2.877831,
      0.715114,
      ' 8-26-1978',
      NULL,
      4.695530,
      NULL,
      NULL,
      5,
      9.479267,
      5.109177,
      3.846260,
      0,
      NULL,
      7.285982,
      0.753197,
      34,
      0.454351,
      NULL,
      9,
      1,
      1.982234,
      1,
      1.689609,
      0.272035,
      ' 9-17-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20.733039,
      ' 8-19-1994',
      29,
      ' 5-18-1991',
      8.054782,
      6.676650,
      ' 8-16-1975',
      126,
      86,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      9.425744,
      NULL,
      1.831472,
      13,
      3.153795,
      ' 6- 6-1995',
      1.322212,
      51.019430,
      NULL,
      NULL,
      31.091056,
      7.083589,
      118,
      NULL,
      65.500649,
      0,
      26.098582,
      ' 8- 4-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


