set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9437107';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0203',
      '32224342',
      '22014300',
      '14231121',
      '02043112',
      NULL,
      '32033444',
      '40320113',
      '32304044',
      '42220022',
      '13040334',
      '00124014',
      NULL,
      '20234342',
      NULL,
      '01340423',
      '41243030',
      '43401243',
      NULL,
      '32211002',
      '20241231',
      '21001301',
      NULL,
      NULL,
      '03004111',
      '34132321',
      '30400013',
      '33102013',
      '14002042',
      NULL,
      '23402200',
      '14120424',
      NULL,
      '33341113',
      '41104303',
      NULL,
      '02432002',
      '40244123',
      '44311031',
      '32311433',
      '30124214',
      '11143131',
      '10430441',
      '13121343',
      '13120213',
      '434',
      '04',
      NULL,
      NULL,
      '3023214',
      3.324611,
      0.449873,
      1,
      NULL,
      NULL,
      2.280600,
      NULL,
      '11-29-1991',
      4.301097,
      NULL,
      NULL,
      7,
      NULL,
      1,
      18.450457,
      13,
      20,
      2,
      19,
      9,
      22.065676,
      2,
      18,
      NULL,
      4,
      22,
      40.650836,
      1,
      23.761208,
      11.456642,
      2,
      1,
      0.285463,
      31.100383,
      137,
      32.956461,
      72,
      200,
      55,
      ' 4-17-1976',
      NULL,
      62,
      6,
      12,
      154.485045,
      NULL,
      ' 9-24-1997',
      1.496524,
      NULL,
      0.462917,
      0.463532,
      NULL,
      3,
      0.396076,
      0,
      0,
      1,
      1,
      1,
      0.553961,
      1.500104,
      NULL,
      1,
      NULL,
      1.751801,
      0.445810,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      NULL,
      6,
      0.541167,
      8,
      6,
      ' 5- 6-1991',
      1,
      0,
      NULL,
      NULL,
      6,
      8.956391,
      1,
      0,
      63,
      NULL,
      NULL,
      NULL,
      ' 6-18-1978',
      29.305404,
      NULL,
      NULL,
      112,
      98,
      8.205954,
      NULL,
      21,
      80.392442,
      18.994243,
      NULL,
      NULL,
      ' 1-12-1989',
      5.721049,
      27.293367,
      3,
      100.790526,
      25,
      NULL,
      15,
      '10-16-1988',
      13.641762,
      NULL,
      ' 3-15-1975',
      4.943977,
      1,
      16.350579,
      8,
      11.125215,
      7.575571,
      3,
      NULL,
      0,
      1.516545,
      7.053127,
      4.714776,
      20.750900,
      NULL,
      1.130150,
      2.695736,
      0,
      0.569021,
      ' 8- 3-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      37.929478,
      NULL,
      ' 2-23-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 3-2003',
      15.297874,
      ' 3-26-1980',
      11,
      9.242836,
      ' 1-16-1986',
      NULL,
      NULL,
      NULL,
      0.756886,
      3,
      '11-15-1975',
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      64.901138,
      17.887461,
      3.333717,
      ' 4-18-2001',
      0,
      NULL,
      ' 1-11-1995',
      5.854542,
      23.769623,
      4,
      33.978742,
      ' 2-23-1998',
      6.739975,
      1.882455,
      30.300377,
      ' 2-18-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


