set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4134',
      NULL,
      '41140103',
      '21140104',
      '30422002',
      '14411002',
      NULL,
      '22423313',
      '44101012',
      '13404402',
      '34443222',
      '21030443',
      '14002414',
      '33122110',
      '43110324',
      '24442310',
      '21243010',
      '00220332',
      '41134302',
      '44112210',
      '44220000',
      '40240032',
      '23111330',
      '32221023',
      '40224122',
      '31210442',
      '12403304',
      '24303241',
      '44244403',
      '22044321',
      '04014233',
      '13212424',
      '14341131',
      '03041232',
      '23410424',
      '33133122',
      '12420441',
      '11122112',
      '42430321',
      '14203012',
      '20420401',
      '00430241',
      '23002440',
      NULL,
      '13100241',
      NULL,
      '33',
      21.472936,
      21.936330,
      '1442230',
      0,
      0.370554,
      0,
      NULL,
      '041220',
      2,
      ' 6-17-1976',
      '11-17-1982',
      3.413416,
      139,
      0,
      1,
      10.601715,
      5,
      35.549645,
      NULL,
      0,
      1.944645,
      22.951172,
      5.118319,
      30,
      17.880071,
      6,
      9.210192,
      1,
      NULL,
      16.326180,
      15.481328,
      27,
      0,
      99.417528,
      5,
      0,
      27,
      136,
      53.774351,
      77.106696,
      NULL,
      12,
      '10-11-1993',
      42.208802,
      5.538779,
      18,
      8.497843,
      216,
      129.552720,
      ' 9- 0-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      84.060101,
      14.357877,
      19.710906,
      10.650234,
      25,
      NULL,
      NULL,
      1.880554,
      1.578461,
      68.445246,
      0.566554,
      0.296457,
      NULL,
      1.960170,
      0.805317,
      37.278849,
      NULL,
      NULL,
      NULL,
      '11- 8-1974',
      41,
      43,
      NULL,
      NULL,
      3,
      NULL,
      38.670302,
      3.383510,
      NULL,
      84.486822,
      28,
      40,
      ' 7-15-1980',
      NULL,
      NULL,
      NULL,
      61.811439,
      80,
      42.655512,
      2.934539,
      ' 8- 8-1983',
      7,
      0,
      NULL,
      1.832449,
      9,
      13,
      11.821098,
      9,
      3.898726,
      NULL,
      22,
      1,
      28,
      1.053578,
      14,
      3.540615,
      8.250174,
      0,
      NULL,
      0.125746,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.276176,
      ' 0-27-1989',
      30,
      NULL,
      2.177440,
      NULL,
      ' 2-23-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      27,
      ' 9-12-1989',
      67.051094,
      0.920192,
      NULL,
      ' 9- 3-1985',
      0,
      7.686637,
      '11-25-1980',
      0,
      3,
      16.460614,
      69,
      ' 5-16-1992',
      NULL,
      1,
      32.135145,
      ' 8-15-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


