set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      '4',
      '1',
      '4',
      NULL,
      '2',
      '2',
      '3',
      '1',
      '4',
      '0',
      '2',
      '3',
      NULL,
      '4',
      '0',
      '1',
      '2',
      '2',
      '1',
      '0',
      '2',
      '4',
      '',
      '3',
      '',
      '2',
      '4',
      '2',
      '0',
      NULL,
      NULL,
      '',
      '4',
      '0',
      '3',
      NULL,
      '2',
      '2',
      '0',
      '0',
      NULL,
      '0',
      '0',
      '111',
      NULL,
      38.054984,
      40,
      '3110403',
      NULL,
      NULL,
      0,
      NULL,
      '102042',
      NULL,
      ' 8-16-1979',
      '11- 2-1992',
      62.619216,
      16.485957,
      11.649918,
      11,
      15,
      4,
      40.644975,
      NULL,
      5.317041,
      4,
      6,
      0,
      NULL,
      2.216464,
      26.810863,
      2,
      NULL,
      6.251168,
      50,
      14.111406,
      35,
      NULL,
      NULL,
      21,
      1,
      NULL,
      NULL,
      17.932972,
      17.800740,
      73,
      78.537980,
      ' 3-22-1991',
      40,
      37,
      10.241165,
      NULL,
      212,
      144.262707,
      ' 5-15-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      69.985555,
      NULL,
      8.477883,
      4,
      3.595628,
      0.627551,
      ' 7- 8-1980',
      1.620781,
      0.262178,
      145,
      0.442047,
      0.099250,
      67,
      1,
      2,
      14.319780,
      NULL,
      NULL,
      NULL,
      ' 1-15-1986',
      NULL,
      NULL,
      44,
      17,
      31.704898,
      34,
      58.729746,
      NULL,
      62,
      30.700800,
      72,
      10,
      ' 5- 1-1988',
      16.836978,
      18.520698,
      NULL,
      27,
      67,
      38.902635,
      5.397135,
      NULL,
      3,
      1,
      ' 5-11-1975',
      13.758644,
      NULL,
      18.238405,
      6,
      4,
      0,
      0,
      21.192435,
      NULL,
      55.160868,
      0.397048,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      123,
      NULL,
      ' 6- 4-1989',
      NULL,
      NULL,
      NULL,
      7.001884,
      ' 8-22-1994',
      38,
      ' 9-22-1984',
      9.092641,
      8,
      '10-17-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      26,
      NULL,
      NULL,
      38.629184,
      8.900084,
      ' 4- 2-1975',
      0.932319,
      NULL,
      ' 2- 6-1986',
      2.026148,
      94,
      18,
      NULL,
      ' 4-26-2003',
      NULL,
      0.821195,
      82.730282,
      ' 1-20-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


