set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      '4',
      '4',
      '1',
      '2',
      NULL,
      '2',
      '0',
      '1',
      '0',
      '3',
      '3',
      NULL,
      '4',
      '3',
      '1',
      '1',
      '3',
      '4',
      '0',
      '1',
      '3',
      '1',
      '',
      NULL,
      '',
      '0',
      '3',
      '4',
      '4',
      '1',
      '',
      '',
      '2',
      '0',
      NULL,
      '2',
      '2',
      NULL,
      '4',
      '4',
      '0',
      NULL,
      '4',
      NULL,
      '31402202',
      NULL,
      NULL,
      '4412422',
      0.206311,
      89,
      NULL,
      1,
      '244022',
      5.025151,
      ' 2- 1-1995',
      ' 5-19-1978',
      210,
      0.585754,
      20.952734,
      8,
      1.235305,
      6.948448,
      28.324498,
      7,
      19.535076,
      17,
      NULL,
      1,
      42,
      15,
      21,
      1.385385,
      5,
      20.999815,
      16.471050,
      2.632414,
      41.848165,
      3,
      16.900367,
      11,
      1,
      14,
      83,
      36.460234,
      NULL,
      NULL,
      NULL,
      ' 0- 0-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      220.452266,
      NULL,
      '10-12-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      4.615972,
      5,
      4,
      NULL,
      0,
      3,
      116,
      0.063066,
      NULL,
      85.402615,
      0.847192,
      0,
      28,
      NULL,
      NULL,
      NULL,
      ' 5-26-1982',
      17.635447,
      87.977594,
      NULL,
      19,
      88.803689,
      13,
      32.350834,
      71.439998,
      1.014711,
      13,
      20,
      NULL,
      ' 9-13-2003',
      23,
      28.913703,
      17.999951,
      1.894270,
      NULL,
      95,
      8,
      ' 5- 7-1995',
      16.665982,
      NULL,
      ' 2- 1-1986',
      9,
      NULL,
      16.029027,
      8,
      14,
      10.426265,
      0.155570,
      3.807301,
      0,
      122,
      1,
      9.043076,
      13,
      22,
      NULL,
      1,
      0.589417,
      1.667369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      174,
      2.014375,
      ' 0- 2-2003',
      NULL,
      NULL,
      NULL,
      11,
      ' 0-26-1986',
      29.584396,
      ' 6-12-1991',
      NULL,
      1.594643,
      NULL,
      78,
      129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      21,
      ' 1- 5-1984',
      9,
      47.488100,
      15,
      ' 8- 8-1992',
      1,
      79.885337,
      ' 6-23-1984',
      8.077491,
      52,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      175,
      ' 9- 8-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


