set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9805950';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      '1',
      '2',
      '4',
      NULL,
      '0',
      '4',
      '4',
      '0',
      '2',
      '0',
      NULL,
      '2',
      NULL,
      '4',
      '3',
      '3',
      NULL,
      '4',
      '4',
      '4',
      '3',
      '3',
      '',
      '1',
      '',
      '3',
      NULL,
      '1',
      '2',
      '3',
      NULL,
      '',
      '0',
      '0',
      '4',
      '2',
      '1',
      '2',
      NULL,
      '1',
      '0',
      '0',
      '2',
      '201',
      '44434032',
      44,
      NULL,
      NULL,
      2.701494,
      0.674032,
      0,
      NULL,
      '400142',
      1,
      ' 1- 2-1991',
      ' 7-13-1974',
      78.172735,
      NULL,
      42.907291,
      NULL,
      33.741613,
      9,
      61.649338,
      6,
      28,
      NULL,
      7.496067,
      0,
      11.544250,
      5.709851,
      16.351061,
      2.210435,
      15,
      2,
      10,
      1.211175,
      71.225969,
      7,
      NULL,
      NULL,
      1.200464,
      143.583974,
      204.990635,
      36.592435,
      245.643297,
      162,
      59.652910,
      NULL,
      67,
      NULL,
      9.180853,
      11.670246,
      128,
      103,
      '10-21-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      60.590852,
      24.030193,
      17,
      2,
      17,
      4,
      '10-28-1988',
      1,
      NULL,
      194,
      1.042311,
      0.423015,
      32,
      NULL,
      NULL,
      20,
      NULL,
      NULL,
      NULL,
      ' 0-13-1998',
      63.418607,
      14,
      67.943222,
      3,
      68,
      48.881282,
      57.993530,
      NULL,
      65,
      65,
      13,
      58,
      ' 1-15-1975',
      9.632935,
      34,
      4,
      46,
      NULL,
      85,
      2,
      ' 5-17-1994',
      29,
      15.763819,
      NULL,
      7.448895,
      11.751820,
      10,
      6.421921,
      17.544612,
      NULL,
      2,
      24.406688,
      0,
      14.825382,
      3,
      0.874741,
      9,
      3.097057,
      NULL,
      0,
      1,
      NULL,
      ' 5-19-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      115,
      NULL,
      '10-20-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 9-1993',
      12.220685,
      ' 2-23-1989',
      13.201757,
      NULL,
      ' 5-22-1987',
      127,
      80.911352,
      ' 8-15-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      23.190879,
      NULL,
      49.596169,
      NULL,
      43,
      ' 0- 5-1976',
      2.917894,
      NULL,
      ' 5- 6-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


