set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9805950';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '3',
      '1',
      NULL,
      '1',
      '3',
      '4',
      NULL,
      '0',
      '2',
      '4',
      '1',
      '3',
      NULL,
      NULL,
      '3',
      '4',
      '2',
      '3',
      NULL,
      NULL,
      '4',
      '2',
      '',
      '2',
      '',
      NULL,
      '3',
      '3',
      '0',
      '4',
      NULL,
      '',
      '4',
      '1',
      NULL,
      '3',
      '0',
      '2',
      '2',
      '3',
      '2',
      '0',
      '2',
      '101',
      '31341443',
      10.021127,
      64,
      '2224422',
      3.610439,
      1,
      1,
      0,
      '001010',
      2.236394,
      '11- 3-1994',
      '10-24-1986',
      5.002728,
      115,
      40.055668,
      32,
      NULL,
      17,
      35,
      NULL,
      34.045458,
      30.314162,
      NULL,
      22,
      NULL,
      24,
      NULL,
      NULL,
      10,
      4.580916,
      16,
      7,
      31,
      26,
      108,
      3,
      1.259124,
      NULL,
      144,
      111.616950,
      31.959380,
      172,
      NULL,
      '10-26-1980',
      NULL,
      24.740974,
      33,
      29,
      NULL,
      4.870592,
      ' 0-20-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      113.668171,
      3.694208,
      NULL,
      3.205052,
      8.950782,
      6.969993,
      '11-15-1989',
      0,
      3.217067,
      32.656033,
      0,
      NULL,
      NULL,
      0.708443,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      60,
      90,
      NULL,
      NULL,
      NULL,
      69,
      55.141910,
      25,
      61.158009,
      66.861188,
      21.447795,
      81,
      NULL,
      6.951016,
      NULL,
      30.278623,
      NULL,
      65.379400,
      112,
      9,
      '10-16-1979',
      22,
      25,
      ' 4-20-2001',
      6,
      18.475663,
      NULL,
      16.180637,
      7.780103,
      NULL,
      0,
      14,
      1,
      62,
      7,
      0.710951,
      4.192352,
      13.276172,
      5.749392,
      1,
      0.532835,
      NULL,
      ' 6- 5-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      118.829108,
      NULL,
      ' 7-21-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 0-1990',
      40,
      NULL,
      0.306279,
      15,
      NULL,
      64,
      101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      25.969489,
      NULL,
      39,
      13,
      36,
      NULL,
      NULL,
      139.721584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


