set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8524572';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4233',
      NULL,
      '23412140',
      NULL,
      '42024404',
      '30422030',
      '10343103',
      '40103024',
      '03110341',
      NULL,
      '10343433',
      '33321042',
      '01102210',
      '23241134',
      '12431213',
      '00314114',
      '13430440',
      '24142220',
      '04200222',
      '21223003',
      NULL,
      '21113114',
      NULL,
      '32404431',
      '13320232',
      '03003243',
      '44413203',
      '03210231',
      '12323123',
      NULL,
      '14211000',
      NULL,
      '13122402',
      '32300430',
      '02332113',
      NULL,
      '20020020',
      '41232004',
      '23213102',
      NULL,
      '14433304',
      '32233034',
      '22133132',
      '03311034',
      '01203133',
      '',
      '',
      NULL,
      NULL,
      '1021240',
      1,
      1,
      3,
      NULL,
      '413011',
      NULL,
      ' 3- 8-1995',
      ' 3- 2-1985',
      30,
      NULL,
      NULL,
      0,
      11.368396,
      NULL,
      92.314865,
      7.300592,
      NULL,
      7.030900,
      9,
      1,
      38.189696,
      6,
      NULL,
      12.254373,
      NULL,
      7,
      NULL,
      NULL,
      48.574009,
      11.338994,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      31.974192,
      82,
      101.938232,
      ' 6- 0-1993',
      16.064851,
      37,
      NULL,
      22.257169,
      32,
      48.110521,
      ' 7-26-1980',
      2.859425,
      1.162633,
      2.579178,
      1.366205,
      NULL,
      NULL,
      NULL,
      NULL,
      1.797809,
      NULL,
      2,
      0.588622,
      0.016884,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 1-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-17-1996',
      55,
      120.906564,
      6,
      36.074063,
      93,
      45,
      120.884344,
      99,
      0,
      103,
      22.283932,
      100,
      NULL,
      NULL,
      NULL,
      1.822366,
      NULL,
      62,
      59,
      11,
      '10- 8-1996',
      14,
      6,
      ' 8-23-1987',
      6,
      5.892833,
      7,
      24.577803,
      13,
      NULL,
      NULL,
      18.572388,
      NULL,
      22,
      3.462131,
      0,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-25-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      69,
      27.741637,
      24,
      ' 6- 0-1975',
      0.570954,
      122,
      '11-11-1985',
      14,
      15.013244,
      NULL,
      31,
      ' 9- 3-2002',
      5.353641,
      1.581222,
      37.102398,
      NULL,
      NULL,
      NULL,
      NULL,
      86.857743,
      62,
      1.393813,
      89.178460,
      46,
      157.955759,
      41,
      34.531459,
      2.492912,
      20,
      5.485121,
      NULL,
      NULL,
      0.082633,
      NULL,
      0,
      0,
      92,
      0,
      1,
      171,
      NULL,
      1.574154,
      232.041605,
      86,
      2.236006,
      NULL,
      NULL,
      NULL,
      0,
      0.296017,
      0.007945,
      1.242102,
      0.375171,
      1,
      98.924877,
      61.671777,
      38.195008,
      23,
      NULL,
      70.836167,
      NULL,
      NULL,
      NULL,
      1.144686,
      0.981779,
      0.551694,
      11,
      NULL,
      56.070151,
      0.898541,
      16.456503,
      1,
      1,
      91,
      35,
      14.855048,
      32,
      114,
      12,
      23,
      84.897407,
      6.611973,
      10,
      NULL,
      0.020688,
      0,
      0,
      1,
      0,
      32.641189,
      ' 1-12-1985',
      NULL,
      ' 4-17-1985',
      ' 4-24-2002',
      NULL,
      ' 4-18-1991',
      ' 6-14-1977',
      NULL);
commit;
end;
/


