set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5715854';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4301',
      NULL,
      '20014103',
      '20440010',
      '33400433',
      '13040444',
      NULL,
      NULL,
      '33411441',
      NULL,
      '22303032',
      '44041032',
      '13120421',
      '20204434',
      NULL,
      '34304031',
      NULL,
      '12410321',
      NULL,
      '21231342',
      '20342010',
      NULL,
      NULL,
      '34211310',
      '33014300',
      '03321323',
      NULL,
      '12040132',
      '21121231',
      NULL,
      NULL,
      '44443243',
      '10031401',
      '31314031',
      '21321414',
      '22322200',
      '13004130',
      '14013212',
      NULL,
      '23132122',
      '14221113',
      '11302211',
      '42430334',
      '00300121',
      '20442040',
      '211',
      '24',
      32.386912,
      NULL,
      '0424322',
      1,
      1.254608,
      0,
      NULL,
      '003134',
      NULL,
      NULL,
      ' 4-29-1989',
      28,
      20,
      7.636370,
      8.040419,
      7,
      12,
      51,
      11.498764,
      10,
      2.118970,
      NULL,
      NULL,
      5.966115,
      5,
      0,
      6.193232,
      2.538579,
      8,
      NULL,
      10,
      33.398369,
      7,
      7.697757,
      9.894098,
      1,
      67,
      60.937261,
      25,
      NULL,
      104,
      51.491862,
      ' 7-21-2000',
      NULL,
      11.345804,
      11,
      15.234590,
      30.709387,
      17.647873,
      ' 0-20-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.222336,
      40,
      4,
      ' 2- 6-1981',
      0.657800,
      1.549831,
      19,
      0.859657,
      1.635761,
      17.312589,
      0.897622,
      1,
      11.697842,
      NULL,
      NULL,
      NULL,
      NULL,
      80,
      97,
      26,
      32,
      33,
      88.986398,
      NULL,
      NULL,
      23.090181,
      28,
      39.828676,
      41.921295,
      ' 0-23-1979',
      13.513187,
      16.531009,
      5.812792,
      32,
      51,
      56.197297,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 3-1996',
      1,
      9,
      NULL,
      1.419450,
      13,
      1,
      0.707368,
      4,
      1,
      NULL,
      0.285949,
      15.077750,
      0.194920,
      NULL,
      0,
      0,
      1.025702,
      NULL,
      ' 7-22-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.017521,
      ' 6-28-1981',
      NULL,
      NULL,
      NULL,
      36,
      ' 0-27-1974',
      35.272288,
      ' 0-26-1993',
      10.445553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 2- 4-1975',
      10.456407,
      21.805019,
      29.232233,
      '11- 6-1976',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6.332601,
      65,
      NULL,
      48.979138,
      1,
      73,
      '11-29-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


