set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9129808';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2433',
      NULL,
      '44113014',
      '22002412',
      '42033301',
      '34432430',
      '44124321',
      '20141432',
      NULL,
      '14322222',
      '21444220',
      '24304123',
      '10001244',
      '01301200',
      '41102321',
      '41043010',
      NULL,
      '44400404',
      '42001442',
      '23404411',
      '03102233',
      '31243003',
      '21344312',
      NULL,
      '10441243',
      '32020224',
      NULL,
      '12003102',
      '24122141',
      '14323223',
      '10334434',
      '30034014',
      NULL,
      '44221334',
      '40030124',
      '02133001',
      NULL,
      '03220114',
      '33411211',
      '01414413',
      '14143242',
      NULL,
      NULL,
      NULL,
      '41200431',
      NULL,
      '',
      NULL,
      NULL,
      '3220021',
      2,
      0,
      3,
      NULL,
      '103303',
      2.570139,
      ' 6- 3-1978',
      ' 5- 2-1986',
      3,
      NULL,
      NULL,
      7,
      20,
      NULL,
      11,
      11.180449,
      7,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      15.182449,
      5,
      3,
      8,
      16.120971,
      8.618579,
      5.876022,
      2.232212,
      4,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      145,
      44.761781,
      83,
      '11- 9-1983',
      0,
      4,
      NULL,
      16.013474,
      155,
      115,
      '11- 3-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-11-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.142972,
      2,
      7,
      26.694070,
      1.437888,
      5,
      2.228134,
      NULL,
      NULL,
      0,
      '10-15-1980',
      2.473387,
      5.764382,
      0,
      3.732883,
      5,
      1.150638,
      NULL,
      5,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.488165,
      15.017978,
      ' 5-27-1978',
      2,
      158.369744,
      ' 9-14-1988',
      NULL,
      18.947111,
      0.920484,
      31.673340,
      NULL,
      NULL,
      NULL,
      168,
      ' 8-26-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      95.190946,
      86.001338,
      NULL,
      70,
      43.422814,
      2.079739,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.950771,
      161,
      2.456656,
      NULL,
      59.330891,
      NULL,
      5,
      NULL,
      1.479615,
      NULL,
      4.458407,
      NULL,
      1,
      2.795088,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      13.754703,
      NULL,
      NULL,
      0.673248,
      3,
      13,
      0,
      9,
      1.089769,
      NULL,
      0.106051,
      NULL,
      NULL,
      NULL,
      1.708321,
      NULL,
      NULL,
      7.032072,
      NULL,
      NULL,
      NULL,
      NULL,
      1.073562,
      NULL,
      NULL,
      42,
      0,
      NULL,
      10.620751,
      0.530673,
      0.344866,
      0,
      NULL,
      ' 4- 4-1997',
      ' 9-29-1978',
      ' 3-10-1976',
      ' 9-22-1989',
      ' 2- 6-1993',
      NULL,
      NULL,
      NULL);
commit;
end;
/


