set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7717600';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0032',
      '21323224',
      '24241144',
      '13111342',
      '31241333',
      '44200121',
      '33414323',
      '30122011',
      '12332420',
      '00121341',
      '23114304',
      '42232102',
      NULL,
      NULL,
      '30311104',
      '14023322',
      '23111241',
      '01032032',
      '30221041',
      '32104414',
      '10203424',
      NULL,
      '22011032',
      '33010242',
      '44111302',
      '14440020',
      NULL,
      NULL,
      NULL,
      '20043012',
      '03342000',
      '11012112',
      '22332323',
      '10314212',
      NULL,
      '24343411',
      '03134334',
      '03112423',
      '21343441',
      '44323112',
      '04420334',
      NULL,
      '20342142',
      NULL,
      '40323141',
      '224',
      '23',
      NULL,
      NULL,
      '2144410',
      0.575025,
      1.242075,
      0,
      NULL,
      '000322',
      0.662154,
      '11-23-1983',
      ' 9-23-1997',
      19,
      NULL,
      40,
      5.565416,
      7,
      1,
      NULL,
      26.368179,
      20.851088,
      3.832013,
      NULL,
      NULL,
      17.736548,
      18.064405,
      17,
      0,
      11.503544,
      23,
      32.219816,
      8,
      NULL,
      NULL,
      NULL,
      10.010978,
      1,
      4.003891,
      191.590484,
      41,
      154.882124,
      115,
      211,
      ' 1-13-2002',
      30,
      NULL,
      26.079346,
      NULL,
      78,
      85.622330,
      ' 6- 3-1993',
      4.774158,
      2,
      0.954705,
      1,
      1.999705,
      1.220848,
      0.872305,
      3.260201,
      1.644032,
      1,
      0,
      0,
      0.263094,
      5.934312,
      NULL,
      0.070551,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 8-1986',
      21.078584,
      38.861981,
      4.252271,
      6,
      8,
      NULL,
      ' 8-22-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67.113799,
      6.441824,
      NULL,
      29,
      39.219809,
      94.332149,
      NULL,
      NULL,
      53.647522,
      28,
      34,
      31.961135,
      NULL,
      7,
      30,
      26.872018,
      16,
      9.431373,
      NULL,
      3.221366,
      ' 5- 0-1986',
      35.559736,
      17.261854,
      NULL,
      2,
      4.884134,
      3,
      NULL,
      3.819598,
      10,
      0.549541,
      13,
      0.442655,
      NULL,
      0,
      1,
      6,
      16,
      5,
      NULL,
      0.540382,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-16-2002',
      NULL,
      12.803457,
      ' 9-22-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 8-1984',
      20,
      NULL,
      2.991164,
      8.453230,
      NULL,
      NULL,
      NULL,
      ' 6- 6-1982',
      6.936040,
      1,
      ' 8- 5-1977',
      0.885686,
      0.874472,
      ' 2- 1-2003',
      NULL,
      0,
      9.412132,
      '10-17-1999',
      23,
      NULL,
      45,
      ' 8-13-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.258781);
commit;
end;
/


