set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6508568';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3444',
      '00220103',
      '23422234',
      '24132103',
      '43223122',
      '23212100',
      '33020242',
      '13323241',
      NULL,
      '04130010',
      '14244333',
      '24204222',
      '23001140',
      NULL,
      '14303022',
      NULL,
      NULL,
      '10313020',
      '24300042',
      '44232214',
      '00043422',
      NULL,
      '21103443',
      '13041211',
      '21332023',
      '33211323',
      '11430301',
      '21414141',
      NULL,
      NULL,
      NULL,
      '31014022',
      '14141341',
      '23333312',
      NULL,
      '14303204',
      '41213242',
      '22030313',
      NULL,
      '43100140',
      '14110003',
      '42412313',
      '12401004',
      '11022300',
      '30310414',
      '043',
      '24',
      29.486318,
      15.874387,
      NULL,
      0,
      1.278763,
      1,
      NULL,
      '222313',
      5.852043,
      ' 7- 9-2002',
      NULL,
      91,
      61,
      38.088934,
      12.794471,
      29,
      25.879719,
      63.005684,
      NULL,
      14.331170,
      21,
      NULL,
      NULL,
      33,
      13,
      31.700156,
      4.171773,
      27,
      20,
      41,
      13.362650,
      3.036680,
      20,
      110,
      3.375102,
      1,
      60.091748,
      84,
      20.313690,
      81.979926,
      206.157184,
      157,
      ' 5-27-1975',
      NULL,
      69,
      32,
      23,
      NULL,
      163.633365,
      ' 6-26-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47.950669,
      8,
      2.805000,
      9.726821,
      0.394213,
      6.678478,
      ' 6-18-1992',
      1,
      0.036399,
      37.342119,
      1.947940,
      1.567265,
      64,
      0.111859,
      0.639928,
      16.001698,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      3,
      63,
      100,
      NULL,
      61,
      103,
      NULL,
      19.123259,
      84.215457,
      35,
      12,
      '10-27-1988',
      2,
      NULL,
      21.667192,
      46.960410,
      2.594356,
      40,
      12,
      ' 5-13-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.305891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      '10-19-1997',
      7.328051,
      ' 7- 8-1987',
      NULL,
      8,
      ' 8-15-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      13,
      NULL,
      23.791641,
      12,
      NULL,
      NULL,
      1,
      24.737631,
      ' 9-11-2003',
      12,
      5,
      9,
      12.709993,
      ' 9-26-1977',
      22,
      1,
      NULL,
      ' 3-15-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


