set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6508568';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1021',
      '21433014',
      '20301010',
      '34113104',
      '10403022',
      NULL,
      '10200141',
      '43202142',
      NULL,
      '30134102',
      '41124431',
      '02403011',
      '10242042',
      '42230010',
      NULL,
      '10222242',
      '20123420',
      '02310322',
      '40444124',
      '11142002',
      '42433343',
      '14130414',
      '33022241',
      '34004202',
      '22313233',
      '44212321',
      NULL,
      '33024223',
      '22103142',
      NULL,
      '13401333',
      '00242014',
      NULL,
      '14310033',
      '40404213',
      '13134032',
      '42111203',
      NULL,
      '02421314',
      '41420304',
      '43142234',
      '13202100',
      NULL,
      NULL,
      '03134003',
      '030',
      '14',
      4.443064,
      10.682422,
      NULL,
      3.137234,
      36.061501,
      NULL,
      NULL,
      '333440',
      2,
      ' 0-23-1986',
      ' 2- 5-1991',
      115.055460,
      2.346875,
      NULL,
      32.560984,
      12.166434,
      NULL,
      120.763611,
      26,
      23,
      16,
      NULL,
      8.955837,
      2.845312,
      4,
      33.031809,
      6.159704,
      41,
      NULL,
      32.388166,
      16,
      51.983808,
      17,
      106.177710,
      6,
      1.896528,
      11,
      145.355552,
      22.098999,
      NULL,
      247,
      177.546172,
      ' 2-21-2002',
      57.061694,
      51.554995,
      25,
      11.000695,
      200,
      236.538253,
      '10- 3-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.010618,
      7.428285,
      3,
      4.250461,
      7,
      '11-27-1977',
      0.356620,
      1.872477,
      152.683532,
      1,
      NULL,
      105,
      NULL,
      1,
      71,
      NULL,
      NULL,
      NULL,
      '10- 0-1977',
      105.439142,
      NULL,
      89.115555,
      34,
      46,
      67.345716,
      5.568137,
      NULL,
      NULL,
      17.253666,
      62.891237,
      64.491636,
      ' 1-13-1983',
      17,
      17,
      NULL,
      NULL,
      10.903269,
      150,
      NULL,
      ' 3-17-1991',
      12,
      6.659469,
      ' 7- 0-1984',
      3.474400,
      17.629834,
      16,
      7.302340,
      10,
      0,
      0.662735,
      26.959033,
      NULL,
      NULL,
      0.685755,
      0.649583,
      8.193532,
      26,
      0,
      2.563125,
      3.311654,
      NULL,
      ' 6-10-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 0- 1-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      ' 8- 2-1993',
      16,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      14,
      NULL,
      22,
      31,
      20,
      '10-21-1991',
      1.073444,
      NULL,
      ' 7- 5-1994',
      8.577513,
      5,
      22,
      13,
      ' 8-10-1976',
      69,
      1.332008,
      86.507081,
      ' 8- 3-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


