set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8535651';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3412',
      '02200034',
      NULL,
      '40214142',
      '23134334',
      '13202430',
      '30104241',
      '42202443',
      '13410232',
      '34341424',
      '22141110',
      NULL,
      '33324214',
      '23014322',
      '20301001',
      '32022401',
      '34144002',
      '22201332',
      '30443312',
      '42311324',
      '22424421',
      NULL,
      '34401220',
      '23433003',
      '02040034',
      '10233331',
      '23304414',
      '23122443',
      '33230230',
      '32402301',
      '33242242',
      '44340123',
      '14030004',
      '14113201',
      '32220243',
      NULL,
      '30023221',
      NULL,
      '01020413',
      '10000211',
      '42330020',
      '11221043',
      '11110320',
      '33111311',
      '10104400',
      NULL,
      NULL,
      37,
      2,
      '4030101',
      NULL,
      1,
      1,
      NULL,
      '430132',
      2.889565,
      '11-10-1997',
      ' 7-22-1990',
      35,
      NULL,
      4,
      9,
      11,
      15,
      11.890833,
      NULL,
      3,
      2.857175,
      18.088709,
      0,
      NULL,
      15,
      NULL,
      NULL,
      20.288076,
      NULL,
      NULL,
      NULL,
      16.498941,
      18,
      100.590100,
      24,
      NULL,
      57.731543,
      14.868736,
      67,
      NULL,
      50.895610,
      163,
      ' 8-15-1990',
      19,
      44,
      NULL,
      19.510261,
      158,
      170.334963,
      ' 7-25-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      74,
      NULL,
      21.910899,
      23,
      2.198929,
      4,
      ' 6-27-2002',
      NULL,
      0.854822,
      209.778876,
      1,
      1.650492,
      NULL,
      NULL,
      1,
      111.478849,
      NULL,
      NULL,
      NULL,
      '10-14-1982',
      19,
      41,
      72,
      15,
      29,
      76,
      53.764433,
      63.028697,
      17,
      71.364678,
      2,
      56,
      NULL,
      19,
      15,
      27.793108,
      NULL,
      57,
      46,
      1,
      '11-18-1993',
      1.042509,
      6.794372,
      ' 6- 1-1985',
      0.990032,
      12,
      11.866292,
      14,
      27,
      NULL,
      NULL,
      12.563931,
      1,
      64.492391,
      1.497700,
      NULL,
      26,
      17,
      1,
      0.011648,
      1.702890,
      0.041125,
      ' 2-15-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      107,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      56,
      '11-20-1996',
      9,
      '11-28-1987',
      NULL,
      NULL,
      ' 9-11-1982',
      27,
      11.018991,
      ' 9-17-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.224117,
      7,
      45.189972,
      '10-25-2000',
      NULL,
      52,
      '10-21-2003',
      5.517564,
      NULL,
      NULL,
      3,
      ' 0- 3-1990',
      38.409291,
      NULL,
      NULL,
      ' 6- 5-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


