set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6458511';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1020',
      '43130000',
      '30010221',
      '13030313',
      '12420301',
      NULL,
      NULL,
      '13402410',
      '04204141',
      '11143200',
      '10043241',
      '30001313',
      '33333444',
      NULL,
      NULL,
      '02443431',
      '44341141',
      '42123231',
      '42004002',
      '30340411',
      '14322003',
      '01004323',
      '40224003',
      '01010331',
      '02043221',
      '23433231',
      '22230431',
      '33104404',
      '32243411',
      NULL,
      '12040220',
      '43110220',
      '01200402',
      '42312012',
      NULL,
      '01013223',
      '04230310',
      '21403420',
      '33221410',
      '34013033',
      '01221320',
      '44400114',
      '34313422',
      NULL,
      NULL,
      '230',
      '24',
      NULL,
      NULL,
      '2100442',
      0,
      NULL,
      NULL,
      NULL,
      '243321',
      NULL,
      '10-11-1981',
      '11- 5-1996',
      140,
      NULL,
      NULL,
      13.861449,
      1,
      11.672204,
      NULL,
      11,
      NULL,
      NULL,
      13,
      4,
      NULL,
      19,
      19,
      6,
      NULL,
      11.240786,
      50.770141,
      17,
      19,
      18.782790,
      13,
      3.725099,
      1.174870,
      NULL,
      108,
      0.303648,
      157.248273,
      1.303912,
      47,
      '10-19-1974',
      49.736182,
      23,
      19.773600,
      8,
      58.359271,
      NULL,
      '10-29-1998',
      4,
      0.827635,
      3.939129,
      NULL,
      6,
      1.824003,
      0,
      2,
      0.729194,
      0.005796,
      3,
      NULL,
      1,
      0.013572,
      1.933754,
      1,
      NULL,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-28-1984',
      28.854428,
      6.910234,
      21.938461,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      0.322502,
      39,
      0,
      0.458515,
      43.402018,
      NULL,
      1.353521,
      22.605319,
      1.873022,
      0,
      109,
      ' 9-23-1982',
      114,
      NULL,
      7.354795,
      64.493595,
      76,
      30,
      NULL,
      20.759953,
      NULL,
      84.034181,
      NULL,
      41,
      ' 8-16-1998',
      NULL,
      13.913488,
      3,
      16.084680,
      NULL,
      21.470704,
      9.353923,
      ' 6-17-1988',
      2,
      NULL,
      ' 5-21-1981',
      3.237897,
      NULL,
      5.586844,
      NULL,
      3.019799,
      NULL,
      NULL,
      4,
      1,
      35,
      5,
      NULL,
      5.242427,
      11,
      NULL,
      3.257285,
      3.718650,
      0,
      ' 7- 3-1986',
      3,
      1.936077,
      1.919233,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      18.671185,
      ' 9-20-1992',
      26,
      ' 3- 0-1978',
      1.325991,
      10.756179,
      '10-28-1977',
      110.588768,
      26.979820,
      NULL,
      5,
      NULL,
      ' 6-25-1988',
      1.493519,
      NULL,
      ' 3- 1-2003',
      1,
      NULL,
      15.324240,
      ' 6- 1-1980',
      29.691186,
      10,
      4.310182,
      ' 1-14-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


