set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7055866';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      NULL,
      '4',
      '1',
      '1',
      '4',
      '3',
      '3',
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      '0',
      '4',
      '3',
      '3',
      '1',
      '1',
      '1',
      '1',
      NULL,
      '0',
      '',
      '2',
      '',
      '0',
      NULL,
      '0',
      '3',
      '0',
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      '2',
      '0',
      '4',
      NULL,
      '4',
      '4',
      '2',
      NULL,
      '212',
      '12210110',
      29.462074,
      27,
      '3241012',
      0,
      1.109751,
      NULL,
      NULL,
      '031022',
      2,
      ' 6- 8-1988',
      NULL,
      53.474832,
      174.838315,
      NULL,
      3,
      16,
      1.536657,
      82.752678,
      16.745293,
      31.275173,
      8.563031,
      NULL,
      9.665353,
      47.309675,
      3,
      35,
      NULL,
      NULL,
      25.496016,
      NULL,
      NULL,
      35,
      24,
      61.033525,
      22,
      0.989074,
      136,
      18.766711,
      25,
      161.951405,
      171.414152,
      82.187639,
      ' 4-29-1982',
      9.816058,
      35.677212,
      NULL,
      23,
      172.728102,
      60,
      ' 0-25-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      80.641923,
      5.771920,
      1.926827,
      8,
      4.070089,
      NULL,
      ' 3-29-1975',
      1.409865,
      0.382647,
      231.739105,
      1,
      NULL,
      45,
      1,
      0.139626,
      107.379218,
      NULL,
      NULL,
      NULL,
      ' 3-19-1981',
      16.603586,
      NULL,
      71,
      22.513277,
      56,
      2.705838,
      43,
      68.013877,
      79.335783,
      71,
      30.395789,
      16,
      ' 0-15-2002',
      13,
      3,
      NULL,
      0,
      64,
      111,
      4,
      '10-10-1994',
      14,
      23.619004,
      NULL,
      25,
      14,
      3,
      28.680458,
      30,
      16,
      1,
      31,
      1.690880,
      NULL,
      0.126416,
      NULL,
      14,
      3.849307,
      0,
      1,
      1.277411,
      1.009279,
      ' 2-13-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      24.842707,
      5,
      ' 1- 4-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-22-1977',
      NULL,
      ' 4-13-1987',
      2,
      NULL,
      ' 3-11-1988',
      160.310038,
      13.288593,
      ' 1-22-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      4,
      ' 7- 9-2000',
      NULL,
      42.533240,
      44,
      ' 7-28-1988',
      1.776900,
      54,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


