set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8123228';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4403',
      '31221404',
      NULL,
      '14041041',
      '04314441',
      '21100224',
      NULL,
      NULL,
      '21101133',
      '02143213',
      '44343333',
      '40241304',
      '04104314',
      '01103412',
      '43042401',
      '31023132',
      '42041013',
      '20404423',
      '32131121',
      '13121334',
      '03003031',
      '21243142',
      '43240343',
      '43134001',
      '32334221',
      '42234401',
      '23343022',
      '01322111',
      NULL,
      '21412233',
      NULL,
      NULL,
      '30044234',
      '11001112',
      '02441141',
      '33000002',
      '32041113',
      '20431000',
      '20341300',
      '03041434',
      '21434434',
      '13312320',
      '00433213',
      '30130331',
      '00443331',
      '',
      '',
      NULL,
      NULL,
      '0334410',
      0,
      1.224299,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      42.355168,
      NULL,
      0.754922,
      3.043348,
      NULL,
      1.614784,
      0,
      7,
      2.934602,
      7,
      2.874571,
      5.147999,
      NULL,
      9.988992,
      2.585130,
      2.621574,
      9.113849,
      NULL,
      6,
      11,
      8,
      19,
      24,
      0.417372,
      NULL,
      45.425789,
      23.543409,
      NULL,
      NULL,
      51.659292,
      54.958531,
      NULL,
      32,
      28,
      5,
      14,
      58,
      NULL,
      NULL,
      NULL,
      1.179828,
      11,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.570703,
      0.840034,
      NULL,
      0,
      0.179883,
      1.842627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 7-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-10-1983',
      27,
      43.674478,
      16,
      41,
      18,
      22,
      NULL,
      1,
      26,
      28.435524,
      5,
      NULL,
      ' 3-28-1995',
      12.196120,
      7.802306,
      6.799846,
      9.926505,
      25,
      0,
      2.854398,
      ' 3-23-1977',
      NULL,
      1.052646,
      ' 2-16-1995',
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      5,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-26-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      32,
      17,
      ' 1- 3-1985',
      NULL,
      45,
      ' 3- 4-2000',
      6,
      42.360459,
      16,
      49,
      NULL,
      3,
      0.694106,
      516.478474,
      ' 8- 6-1974',
      NULL,
      NULL,
      NULL,
      49.726754,
      30.879548,
      0.019818,
      3,
      19,
      146,
      66.800510,
      NULL,
      32,
      30,
      10.880897,
      51.632289,
      NULL,
      NULL,
      100,
      0,
      0.078724,
      163.012482,
      1,
      NULL,
      9.545675,
      1,
      4.191012,
      97.929003,
      5,
      1.242627,
      37.020547,
      0.463102,
      39,
      0.375771,
      NULL,
      0.795284,
      NULL,
      1,
      0,
      40,
      NULL,
      53,
      24,
      51,
      NULL,
      1,
      0,
      4,
      0.992880,
      3.285286,
      0.091768,
      15.501901,
      0.841654,
      18.788812,
      0.825013,
      14.102610,
      1,
      NULL,
      44,
      5.994066,
      2,
      16,
      44.126486,
      18.145061,
      7,
      51.463308,
      5.604000,
      NULL,
      NULL,
      3,
      5,
      3,
      0.457900,
      0.353411,
      62,
      ' 6- 2-1975',
      ' 5-24-1977',
      ' 9- 9-1983',
      ' 3- 8-1985',
      ' 8-23-1999',
      ' 1-28-1978',
      ' 7-24-1980',
      NULL);
commit;
end;
/


