set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9745837';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '4',
      '4',
      '3',
      '3',
      '3',
      '4',
      '1',
      '4',
      '2',
      '4',
      '2',
      '3',
      '0',
      '2',
      '4',
      '4',
      '4',
      '2',
      '3',
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '0',
      NULL,
      '1',
      '1',
      '',
      NULL,
      '4',
      '4',
      '1',
      '4',
      '2',
      '2',
      '1',
      '3',
      '3',
      '0',
      '0',
      NULL,
      '02',
      31.257449,
      6,
      '0121232',
      1.387528,
      1.705644,
      3,
      NULL,
      '124304',
      2,
      ' 6-24-1992',
      '11-15-1983',
      6,
      NULL,
      30.365764,
      14,
      25,
      NULL,
      78,
      16.287051,
      18.431716,
      16.015041,
      16,
      2.391394,
      17,
      22,
      8,
      15.604331,
      7,
      11,
      NULL,
      17.105409,
      42.302317,
      18.493755,
      31,
      6.542203,
      NULL,
      11.267515,
      74,
      NULL,
      98,
      178,
      NULL,
      ' 3-19-1993',
      68.512233,
      NULL,
      33.547002,
      31.992425,
      77.191916,
      NULL,
      ' 4-28-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      54.093016,
      NULL,
      NULL,
      5,
      0,
      ' 7-29-1980',
      1.639299,
      0.817919,
      118.247500,
      1,
      0,
      54.715936,
      NULL,
      1,
      43.513986,
      NULL,
      NULL,
      NULL,
      ' 7-18-2002',
      NULL,
      35,
      14.150888,
      34.918862,
      11,
      NULL,
      NULL,
      47.235391,
      NULL,
      77.559776,
      NULL,
      NULL,
      '10-27-1977',
      18,
      10,
      3,
      43,
      35,
      NULL,
      6,
      NULL,
      29.736004,
      11,
      NULL,
      5,
      13,
      4,
      13,
      23.228861,
      NULL,
      0.005679,
      0,
      0.121003,
      14,
      NULL,
      0.575077,
      NULL,
      0.602158,
      10.147752,
      19.906240,
      1,
      1,
      ' 1-22-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.622821,
      ' 8-28-1974',
      NULL,
      NULL,
      NULL,
      50.393903,
      NULL,
      18.062139,
      NULL,
      3.951839,
      9,
      ' 2- 1-1992',
      NULL,
      NULL,
      ' 5- 2-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      16.170343,
      ' 1-13-1987',
      63,
      25.763639,
      NULL,
      ' 3- 7-1984',
      0,
      NULL,
      ' 2- 2-1989',
      5.484951,
      7,
      11,
      11,
      ' 7- 4-1993',
      50.508446,
      0.454867,
      20.084398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


