set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9745837';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      '2',
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '2',
      '2',
      '0',
      '4',
      '1',
      '2',
      '2',
      '1',
      '2',
      '2',
      NULL,
      '4',
      NULL,
      NULL,
      '3',
      '',
      '0',
      '',
      '0',
      '3',
      '2',
      NULL,
      '1',
      '',
      NULL,
      '4',
      '2',
      '4',
      '3',
      NULL,
      '0',
      '0',
      NULL,
      '1',
      '4',
      '3',
      '334',
      NULL,
      3,
      NULL,
      '2323120',
      NULL,
      27.123293,
      0,
      NULL,
      '100114',
      3.194497,
      '10-10-1974',
      ' 2- 2-1981',
      29,
      59.718257,
      42.050863,
      19.884946,
      3,
      3.376878,
      5,
      13,
      13,
      NULL,
      5,
      6.007290,
      NULL,
      14,
      NULL,
      9.121393,
      31.060785,
      7.793520,
      1.273070,
      9.055520,
      48,
      7,
      25.022790,
      11,
      NULL,
      36,
      NULL,
      45.008369,
      NULL,
      8.794593,
      31.055802,
      NULL,
      29,
      NULL,
      NULL,
      5.960638,
      118.552984,
      NULL,
      ' 6-19-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25.636554,
      65,
      25,
      41.765706,
      21.298471,
      3,
      ' 0-24-1989',
      1,
      0.695930,
      NULL,
      1.564595,
      1,
      43.732259,
      1,
      0,
      41.387925,
      NULL,
      NULL,
      NULL,
      ' 3- 5-1979',
      52.998885,
      40.918923,
      36,
      27.207912,
      92.762589,
      39.670313,
      97.483106,
      101,
      103,
      21.563631,
      79,
      57.850321,
      ' 6- 9-1990',
      8,
      6.120726,
      7,
      0.941847,
      NULL,
      78.985675,
      NULL,
      ' 7-23-2000',
      8.783715,
      7.198597,
      ' 7-27-1987',
      3,
      NULL,
      13.168175,
      NULL,
      6.010837,
      11.661198,
      1.322675,
      NULL,
      NULL,
      8.619774,
      8,
      NULL,
      0,
      9,
      2,
      NULL,
      1,
      1,
      ' 9- 5-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      139.320103,
      1,
      ' 6-10-1996',
      NULL,
      NULL,
      NULL,
      19.639706,
      ' 6-14-1977',
      4.373252,
      ' 5-18-1985',
      NULL,
      0,
      ' 9-21-1991',
      79.242421,
      85,
      ' 4-10-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      14,
      ' 2- 2-1976',
      5,
      26.696241,
      15.391665,
      '11-27-1980',
      NULL,
      69,
      ' 5-19-1996',
      NULL,
      14,
      3,
      11,
      ' 5-25-1979',
      15,
      1.119881,
      5.963601,
      '10-12-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


