set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3402',
      '03014121',
      '44332020',
      '10404230',
      NULL,
      '41333103',
      '00320200',
      '40114112',
      '01240423',
      '31240042',
      '20101203',
      '00411440',
      '13002214',
      '40232402',
      '03124241',
      NULL,
      '24012330',
      '21400101',
      NULL,
      NULL,
      NULL,
      '44143214',
      '44411423',
      '14134332',
      '23233003',
      '03123340',
      '32103130',
      NULL,
      '11222221',
      '42314020',
      '01014443',
      '33022012',
      '20414412',
      '01302441',
      NULL,
      NULL,
      '21401114',
      '02312414',
      '03431422',
      '11313321',
      '23432421',
      '42033212',
      '04011403',
      '02400313',
      '12023314',
      '401',
      '24',
      NULL,
      NULL,
      '0323433',
      3.110066,
      1.664916,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-28-1974',
      ' 6-16-1984',
      109,
      NULL,
      13,
      0.527265,
      6.863705,
      17.451372,
      38.713798,
      15,
      14,
      6,
      21.333206,
      3,
      3,
      5,
      5,
      5,
      9,
      1.394296,
      12,
      8,
      23.839869,
      0.905828,
      69,
      11.063909,
      0,
      70.460884,
      130.502003,
      32.717286,
      99.264155,
      82,
      7.682339,
      NULL,
      NULL,
      8.962004,
      NULL,
      16,
      NULL,
      NULL,
      ' 7-19-1979',
      NULL,
      8.998018,
      3,
      NULL,
      3,
      13,
      6,
      NULL,
      NULL,
      1.078111,
      6.468488,
      0,
      0,
      3.915540,
      3.206398,
      1.723746,
      9.680960,
      1.782953,
      0,
      7.994844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      31.981627,
      17.091334,
      26,
      17.616528,
      NULL,
      ' 2-11-1991',
      NULL,
      0,
      168.864191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 9-1995',
      16.152465,
      81.191382,
      67.830213,
      88.438415,
      107.730653,
      66.117836,
      20.007098,
      105,
      NULL,
      73.083663,
      3,
      NULL,
      '11- 7-1984',
      NULL,
      11,
      2.972536,
      58,
      3,
      NULL,
      4.178879,
      '10-16-1989',
      8.488011,
      5.906052,
      '11-22-1992',
      5.654109,
      19.105861,
      8,
      17.378842,
      9,
      1.704918,
      1,
      6,
      0.960844,
      70.834030,
      NULL,
      14.987982,
      NULL,
      22,
      0,
      NULL,
      0.903973,
      NULL,
      ' 0-13-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.178098,
      ' 6- 6-1976',
      27,
      ' 2-13-1989',
      9,
      15,
      ' 3-28-1982',
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      ' 5-17-1974',
      NULL,
      NULL,
      NULL,
      1,
      0,
      7,
      '10- 6-1981',
      54.445518,
      11,
      24,
      ' 2-20-1995',
      NULL,
      NULL,
      ' 7-28-1996',
      8,
      42.904280,
      23,
      29,
      '10- 9-1976',
      33.001492,
      NULL,
      21,
      ' 3- 5-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


