set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0130',
      '40121022',
      '04332222',
      '00342212',
      '22422404',
      '04414023',
      '30403232',
      '32043441',
      NULL,
      '12202101',
      '43404022',
      '14032124',
      NULL,
      '24211424',
      '32433103',
      NULL,
      '42124402',
      '44232423',
      '01122134',
      NULL,
      '03011132',
      '33101341',
      '12033114',
      '41034042',
      '22433212',
      NULL,
      '23101201',
      '20202434',
      '23242141',
      '41014104',
      '02440121',
      '00430432',
      '21131403',
      '10020013',
      NULL,
      NULL,
      '03100212',
      '31214400',
      '03432423',
      '21321303',
      '04404014',
      '24323333',
      '44004434',
      NULL,
      '12023140',
      '324',
      '40',
      9.127173,
      14,
      '1043113',
      2,
      NULL,
      3,
      NULL,
      '220120',
      0,
      ' 7-25-2002',
      NULL,
      65,
      50,
      NULL,
      NULL,
      17,
      15,
      23,
      0,
      9,
      12.668932,
      8.564707,
      7.113268,
      28,
      8,
      19,
      13.332407,
      13,
      2,
      9,
      6,
      48,
      13.837050,
      NULL,
      13,
      NULL,
      94,
      102,
      27,
      51.450002,
      56.190867,
      123,
      '10- 5-1979',
      4.707474,
      18,
      31,
      NULL,
      14,
      164,
      ' 7- 7-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      79,
      NULL,
      19,
      10,
      1.316556,
      NULL,
      ' 9-11-1974',
      2,
      0,
      12,
      0,
      4.287676,
      NULL,
      NULL,
      2.404814,
      42,
      NULL,
      NULL,
      NULL,
      ' 6-12-1982',
      NULL,
      NULL,
      59.093367,
      10,
      30.891767,
      90,
      91,
      1.034388,
      8,
      7.225991,
      112.643148,
      NULL,
      ' 2-21-2000',
      9,
      22,
      6,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      '10- 3-1977',
      NULL,
      8.658879,
      10,
      10.226406,
      21.778315,
      3.153509,
      1,
      NULL,
      NULL,
      92,
      1,
      1.299913,
      5.591827,
      14,
      6.310995,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      103,
      20.056454,
      ' 1-10-1974',
      NULL,
      NULL,
      NULL,
      0.947260,
      ' 0-24-1991',
      14,
      ' 8-27-1983',
      16,
      7,
      NULL,
      74,
      115,
      ' 9-22-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 2-10-1986',
      58,
      NULL,
      22,
      ' 7- 8-1975',
      0,
      7.688708,
      ' 1- 7-2002',
      1.627958,
      25,
      3.695514,
      14,
      ' 0- 9-1975',
      59,
      NULL,
      10,
      ' 4- 4-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


