set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      '0',
      NULL,
      '2',
      '1',
      '2',
      NULL,
      '0',
      '3',
      '2',
      '0',
      '0',
      '3',
      '4',
      NULL,
      '2',
      NULL,
      '0',
      '4',
      NULL,
      '2',
      NULL,
      '2',
      NULL,
      '0',
      '',
      '4',
      '2',
      '4',
      '0',
      '0',
      '',
      '',
      '0',
      '1',
      '0',
      '3',
      '3',
      NULL,
      '0',
      '2',
      '4',
      '4',
      NULL,
      '233',
      '43',
      43.210669,
      NULL,
      NULL,
      2.779094,
      NULL,
      3,
      NULL,
      '120142',
      5,
      ' 2- 6-2001',
      ' 3-14-1980',
      92.492760,
      64,
      8,
      3.877120,
      14.583317,
      NULL,
      30.512124,
      3,
      13.117748,
      11,
      19.838810,
      0.574168,
      34.496982,
      NULL,
      27,
      14,
      4,
      10,
      28,
      7.761161,
      4,
      11.322998,
      35,
      4.029998,
      1,
      NULL,
      42.473820,
      68,
      157.420497,
      29,
      86,
      ' 5-19-1981',
      NULL,
      NULL,
      22,
      25,
      NULL,
      109,
      '10- 1-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77.116649,
      2,
      1,
      NULL,
      0.145133,
      1,
      '11-23-1988',
      0.932634,
      1,
      175,
      1,
      1.483102,
      106.282702,
      1.758197,
      0.423580,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-25-1994',
      NULL,
      88,
      3.512166,
      86,
      13,
      9.280792,
      72.490084,
      70,
      NULL,
      59,
      38.760028,
      86,
      '10-20-2000',
      15,
      3,
      21,
      6.173197,
      28,
      9.439636,
      1,
      ' 0- 5-1986',
      18,
      NULL,
      ' 4- 0-1985',
      7.873905,
      NULL,
      6,
      10,
      10,
      3.881073,
      1,
      4,
      3,
      60,
      1.400237,
      1.961554,
      NULL,
      29.893484,
      3,
      NULL,
      0.884116,
      1.597228,
      ' 8-14-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      ' 7-19-1988',
      19.054174,
      NULL,
      NULL,
      14,
      NULL,
      42,
      50,
      '10-16-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      21.256260,
      ' 3- 4-1979',
      2.204198,
      28,
      18,
      ' 8- 0-1982',
      2.887188,
      80.818859,
      ' 4-24-1985',
      6.123108,
      NULL,
      18,
      48,
      ' 3-24-2000',
      50.321412,
      0,
      108,
      ' 7- 4-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


