set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '3',
      '0',
      '0',
      '1',
      '3',
      '3',
      '0',
      '4',
      '4',
      '1',
      '3',
      '4',
      NULL,
      '2',
      NULL,
      '4',
      '4',
      '4',
      '3',
      '1',
      '4',
      NULL,
      '',
      '3',
      NULL,
      NULL,
      '4',
      '4',
      '2',
      '3',
      '',
      NULL,
      '3',
      '4',
      '2',
      '0',
      '1',
      '4',
      '1',
      '1',
      '1',
      '3',
      NULL,
      NULL,
      '30320130',
      NULL,
      59.924224,
      '3140241',
      3.091466,
      196,
      1,
      1,
      '423313',
      0.230735,
      ' 6- 2-1990',
      ' 3-27-2003',
      50.982354,
      235.269426,
      17,
      NULL,
      NULL,
      7,
      NULL,
      11.542435,
      15.566389,
      0.754033,
      7.515628,
      8.711693,
      25,
      1.974976,
      8,
      NULL,
      NULL,
      NULL,
      42.883178,
      5,
      NULL,
      NULL,
      69.918549,
      NULL,
      0,
      38,
      65.169906,
      35,
      114.498791,
      NULL,
      115,
      ' 1-17-2001',
      46.824717,
      32,
      11.266272,
      11,
      113,
      142,
      ' 1-12-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      8,
      NULL,
      NULL,
      NULL,
      1.059057,
      ' 7-21-2001',
      1.469185,
      2.298421,
      5.739478,
      NULL,
      NULL,
      68.836659,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-24-1996',
      45,
      NULL,
      4,
      NULL,
      27,
      56,
      43,
      31,
      45.077700,
      100.955417,
      43,
      81.607180,
      ' 2-12-1977',
      23,
      1.183381,
      1.828432,
      5.209767,
      61,
      43.491265,
      2,
      NULL,
      NULL,
      6.475857,
      NULL,
      8.157198,
      5.479298,
      15,
      2,
      15.459469,
      7,
      0,
      7,
      0,
      29,
      0.278414,
      1,
      NULL,
      2,
      1.904538,
      2,
      0.400609,
      0,
      ' 3-25-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.275246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 3-1990',
      44,
      ' 4- 5-1979',
      NULL,
      NULL,
      ' 5- 4-1986',
      33,
      43.974826,
      ' 6- 6-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      16,
      ' 9-12-1976',
      5,
      NULL,
      11,
      ' 5-21-1975',
      3,
      147.371343,
      NULL,
      10.982095,
      3.000938,
      NULL,
      55.981813,
      ' 9-13-1994',
      56,
      NULL,
      118,
      ' 4-20-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


