set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204518';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3000',
      '32001304',
      '01313303',
      NULL,
      '00300403',
      '31240124',
      '41401041',
      NULL,
      '11100311',
      NULL,
      '41230003',
      '03330332',
      NULL,
      NULL,
      '44012334',
      '32412402',
      '02034412',
      '22010200',
      '10044123',
      '41030432',
      '40321103',
      '13131404',
      '24143102',
      '10011203',
      NULL,
      '21414121',
      NULL,
      '30324443',
      '24103411',
      '13201233',
      '41101300',
      '14014444',
      NULL,
      '43401303',
      '44320401',
      '33211120',
      '14312430',
      '20422004',
      '12114241',
      '41242403',
      '23410022',
      '43311324',
      '40134140',
      '10420114',
      '01301103',
      '123',
      NULL,
      NULL,
      NULL,
      '1231031',
      1.526482,
      NULL,
      2,
      NULL,
      '041224',
      2.575196,
      '10-18-1988',
      NULL,
      36,
      NULL,
      21.931458,
      10.001603,
      16,
      1.770813,
      5,
      3,
      NULL,
      0.803204,
      1,
      2,
      7.840769,
      4,
      24,
      7,
      5.893080,
      4,
      14,
      5,
      1,
      NULL,
      1,
      3.967971,
      1.084560,
      NULL,
      NULL,
      42,
      29,
      5.560938,
      105.837715,
      '11-28-1994',
      26,
      NULL,
      11,
      12,
      27.080465,
      52.965746,
      '10-12-1991',
      11,
      8,
      8,
      NULL,
      NULL,
      1,
      NULL,
      2.390233,
      0.616954,
      0.847322,
      NULL,
      NULL,
      NULL,
      1.057535,
      0,
      1.374380,
      NULL,
      1.949593,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 7-1995',
      66.762933,
      15.700346,
      30.895312,
      15.128895,
      23,
      4.781620,
      ' 3- 6-1986',
      0,
      3,
      78,
      3.060781,
      0,
      8,
      0.127791,
      0.854952,
      NULL,
      0.327457,
      0.228627,
      29.136136,
      ' 9- 6-1991',
      35,
      30.203585,
      11.707568,
      2,
      102,
      NULL,
      NULL,
      51.055505,
      88,
      76,
      NULL,
      NULL,
      ' 3-14-1992',
      12,
      13.308964,
      3.856041,
      15.574417,
      73.859688,
      56,
      10,
      NULL,
      0.355508,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.617734,
      NULL,
      NULL,
      ' 3-27-1997',
      NULL,
      38.401731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-21-1980',
      23.310028,
      ' 4-21-1992',
      NULL,
      11,
      '11- 9-1993',
      18,
      37.037168,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      10,
      ' 1-16-1979',
      2,
      1,
      8,
      ' 2-25-1995',
      27.540721,
      4,
      9,
      '10-26-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.360157);
commit;
end;
/


