set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8321755';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '1',
      '3',
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      '0',
      '4',
      '1',
      '2',
      NULL,
      NULL,
      '3',
      '0',
      '',
      '3',
      '',
      '4',
      NULL,
      NULL,
      '1',
      NULL,
      '',
      NULL,
      '4',
      '2',
      '3',
      NULL,
      '3',
      '3',
      '3',
      NULL,
      NULL,
      '0',
      NULL,
      '002',
      '20040421',
      NULL,
      NULL,
      NULL,
      0,
      1.950972,
      0,
      1,
      '202114',
      5,
      ' 9-11-1978',
      ' 2- 1-1993',
      NULL,
      88,
      40.573585,
      19,
      24,
      4,
      25,
      4.090312,
      16.993773,
      12.713929,
      24.485596,
      13.821435,
      31.174189,
      4.500609,
      20,
      NULL,
      20.760342,
      19.206983,
      NULL,
      1.830534,
      2.935309,
      NULL,
      NULL,
      NULL,
      1.751679,
      NULL,
      113,
      42.236516,
      NULL,
      242,
      NULL,
      NULL,
      1,
      1.279014,
      NULL,
      NULL,
      18.156861,
      88,
      '10-25-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      114,
      6,
      3.369501,
      1.672954,
      NULL,
      NULL,
      '10-25-1985',
      0,
      1.449109,
      NULL,
      1.184200,
      5.440722,
      154.778529,
      0.018443,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      63,
      83.374534,
      NULL,
      64,
      58,
      83.609860,
      57,
      23.765215,
      1,
      100,
      55,
      11.320099,
      ' 5- 5-1987',
      NULL,
      14.004848,
      1.139653,
      55,
      33,
      36,
      9.106919,
      NULL,
      9.613557,
      12,
      ' 8- 6-1987',
      1.247035,
      17.896693,
      18,
      NULL,
      21,
      NULL,
      0.216450,
      8,
      1,
      NULL,
      0.048462,
      4,
      18,
      31,
      0,
      NULL,
      NULL,
      NULL,
      ' 0- 6-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      117,
      NULL,
      ' 0-18-2001',
      NULL,
      NULL,
      NULL,
      21,
      ' 4-13-1994',
      38,
      ' 5-22-1997',
      NULL,
      18.202492,
      ' 7-12-1993',
      117.621258,
      92,
      ' 8-14-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      11,
      ' 8-10-1977',
      26,
      49.287991,
      4.603244,
      ' 6-28-2002',
      0.457743,
      5.161649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


