set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9648302';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0120',
      '41344441',
      '24423133',
      '21434432',
      '13302120',
      '32124113',
      NULL,
      '14044320',
      '04434423',
      '40432323',
      NULL,
      NULL,
      '21221110',
      '32432303',
      '32001021',
      '11101020',
      '02144313',
      '32230213',
      '44440342',
      '00123024',
      '22013003',
      '14202110',
      NULL,
      '30131120',
      '32033231',
      '11340204',
      '13344123',
      '21030220',
      NULL,
      '44423004',
      '21323300',
      '04142224',
      '03311313',
      NULL,
      '12324311',
      '00112412',
      '31402230',
      '33043121',
      NULL,
      NULL,
      '20213220',
      '03404144',
      '31102413',
      NULL,
      '34402324',
      '430',
      NULL,
      1,
      NULL,
      '2423110',
      1.797925,
      1.402495,
      NULL,
      NULL,
      '443302',
      3,
      NULL,
      ' 7-18-1975',
      2.666198,
      38,
      6.585517,
      6,
      12.647119,
      2,
      1.194295,
      5,
      8.024591,
      23.474954,
      2,
      17,
      NULL,
      19.327456,
      11.498548,
      8.701434,
      NULL,
      NULL,
      57.052671,
      NULL,
      34.756831,
      NULL,
      35.412397,
      6.518241,
      1.877424,
      120.939803,
      59,
      76,
      41,
      169.287382,
      138.016424,
      ' 8- 0-1974',
      56,
      60.253461,
      19,
      35.514551,
      74.434800,
      72.979966,
      ' 8- 0-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      85,
      NULL,
      18.060330,
      3,
      8.812285,
      2.131721,
      NULL,
      NULL,
      0,
      128.606884,
      0.583696,
      1,
      95.059020,
      NULL,
      1,
      5,
      NULL,
      NULL,
      NULL,
      ' 7-20-1984',
      102.136876,
      NULL,
      39,
      92,
      NULL,
      NULL,
      12.825031,
      52.155180,
      73,
      11.839852,
      NULL,
      88,
      ' 1-15-1994',
      30,
      8.018503,
      11,
      NULL,
      55,
      25.812775,
      6,
      ' 6-21-1977',
      6,
      33,
      ' 1-29-1996',
      NULL,
      7,
      18,
      20.370399,
      7,
      9,
      1,
      0,
      1,
      107.833965,
      1.906806,
      1,
      7,
      10,
      NULL,
      0.182708,
      1.409484,
      0,
      '10-10-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      71.156011,
      14,
      '10- 6-1999',
      NULL,
      NULL,
      NULL,
      0,
      ' 2-18-1977',
      NULL,
      '10-29-1985',
      4.624518,
      6,
      NULL,
      44.321870,
      83,
      ' 9-24-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      22,
      ' 2-26-1989',
      53,
      37,
      32.773310,
      ' 9-13-1994',
      0,
      88,
      ' 8-12-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


