set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9314038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1042',
      '14142404',
      '21032220',
      '44430113',
      '23110011',
      NULL,
      '33200012',
      NULL,
      '14301022',
      NULL,
      '20144004',
      '10231130',
      '33304212',
      '30211410',
      '32042223',
      '02411001',
      '24021333',
      '33213230',
      '40223201',
      '43222042',
      '01011220',
      NULL,
      '44433324',
      '42340104',
      '31312442',
      '21302322',
      '32134001',
      '30040002',
      '42134132',
      '11004031',
      '12024214',
      '24124342',
      '12434044',
      '42220342',
      '00323010',
      '03323210',
      NULL,
      '12212414',
      '34004203',
      '24031400',
      '31423111',
      '42034113',
      '21041412',
      '10122134',
      '10414013',
      '341',
      '02',
      NULL,
      NULL,
      '1431003',
      3,
      1.709573,
      1,
      NULL,
      '402113',
      0.822598,
      ' 0-20-1997',
      ' 5- 4-1980',
      17,
      NULL,
      21,
      3,
      22.469966,
      13,
      18,
      16.141115,
      17.633368,
      12.538094,
      NULL,
      0.345673,
      20,
      0.965919,
      28,
      0.250775,
      NULL,
      17,
      26.029948,
      14,
      28,
      NULL,
      99,
      23,
      1,
      71,
      139,
      60,
      35,
      38.587801,
      27.780416,
      NULL,
      21,
      30.870102,
      0,
      2.547870,
      197,
      NULL,
      ' 4- 3-1986',
      1.039260,
      1.756595,
      3.786098,
      1,
      2.680622,
      1,
      NULL,
      NULL,
      NULL,
      1.342071,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 6-1997',
      31,
      17,
      10.930982,
      5,
      2,
      NULL,
      NULL,
      0.209273,
      NULL,
      125,
      1.643753,
      1.685336,
      20,
      0.400152,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      NULL,
      NULL,
      50.766449,
      32.606755,
      NULL,
      NULL,
      NULL,
      74.175838,
      NULL,
      79.945250,
      30.694784,
      '10-24-1979',
      12.446563,
      1.523877,
      20,
      37.694204,
      49.736334,
      114.112914,
      NULL,
      ' 7-11-2003',
      31.377592,
      34,
      NULL,
      4.326542,
      13.734669,
      27.949294,
      16,
      NULL,
      7.353112,
      1.767894,
      15.418104,
      0.986796,
      10,
      3.391095,
      0,
      NULL,
      NULL,
      1,
      2.707701,
      0,
      0.981540,
      ' 9-19-1983',
      7.001461,
      4.455835,
      1,
      ' 9-27-1976',
      242.511091,
      7.317296,
      ' 4- 4-1982',
      0,
      NULL,
      '11-24-2000',
      51.652515,
      ' 9-10-1981',
      21,
      ' 5-14-1999',
      17.165173,
      6,
      ' 9-26-1981',
      72.481260,
      11,
      ' 8-25-1991',
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      17,
      NULL,
      19.775196,
      30.498828,
      20,
      ' 2- 1-1992',
      1.027159,
      11,
      ' 1- 7-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3);
commit;
end;
/


