set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9806397';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      NULL,
      '0',
      '3',
      NULL,
      '0',
      '3',
      '3',
      '0',
      '0',
      NULL,
      '1',
      '4',
      NULL,
      '1',
      '4',
      '4',
      '0',
      '3',
      '4',
      '2',
      '0',
      '3',
      '',
      '1',
      '',
      '0',
      '4',
      '4',
      '0',
      '2',
      '',
      '',
      '0',
      '0',
      '3',
      '3',
      '2',
      '3',
      '3',
      '2',
      NULL,
      '3',
      NULL,
      '302',
      NULL,
      71,
      21.177125,
      '4242130',
      0.322670,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      ' 1- 6-2002',
      50.025807,
      76,
      42,
      9,
      2,
      19.269487,
      NULL,
      16.071759,
      12.703080,
      NULL,
      1,
      NULL,
      25.081389,
      NULL,
      24,
      11.144763,
      NULL,
      10,
      NULL,
      15,
      22.454076,
      17.865613,
      24.662155,
      NULL,
      0,
      67.650819,
      85.315195,
      44.547854,
      141,
      NULL,
      239.495914,
      '10-24-1974',
      22.980116,
      75,
      10,
      37.293999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      22,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.526146,
      1,
      48,
      1,
      1.415818,
      47.270524,
      NULL,
      1.953205,
      76.168480,
      NULL,
      NULL,
      NULL,
      ' 3- 7-1988',
      49.888488,
      7,
      69.115441,
      6,
      94.342559,
      NULL,
      64.617281,
      13.966474,
      85.208626,
      86.539357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24.434182,
      NULL,
      75.163085,
      170,
      NULL,
      ' 7-10-1975',
      4.242075,
      27,
      '11-21-2002',
      6,
      18.828165,
      11,
      0.518991,
      10.520090,
      6,
      0.186453,
      NULL,
      0.249823,
      40,
      4,
      3,
      6.888864,
      NULL,
      1,
      NULL,
      NULL,
      0,
      ' 7- 4-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 2-20-1980',
      NULL,
      NULL,
      NULL,
      40,
      ' 1-10-2001',
      20.497403,
      ' 6-20-1977',
      10.120922,
      19,
      ' 7- 6-1989',
      7,
      NULL,
      ' 0-27-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      20,
      NULL,
      NULL,
      NULL,
      52,
      ' 0- 8-1976',
      0.731709,
      19,
      ' 5-26-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


