set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115765';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '41344031',
      '02001122',
      '21131141',
      '14233121',
      '42324312',
      NULL,
      NULL,
      '44121034',
      '10444321',
      NULL,
      '00244310',
      NULL,
      '32434040',
      '03214411',
      '41231401',
      '30024010',
      '14233021',
      '04422232',
      '22430240',
      '42344013',
      '00031411',
      '20034040',
      NULL,
      '13211410',
      NULL,
      '20314021',
      '10322011',
      NULL,
      '40111104',
      '01143032',
      '11322144',
      '11441440',
      '41410010',
      '02111413',
      NULL,
      NULL,
      '00331400',
      NULL,
      NULL,
      '43030340',
      '13141223',
      '33442424',
      '03203230',
      NULL,
      '',
      NULL,
      NULL,
      '4233021',
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.169602,
      ' 1- 7-1981',
      NULL,
      1,
      NULL,
      32.267871,
      9.829084,
      13.929620,
      13,
      NULL,
      9.923730,
      25,
      10,
      2.755502,
      22,
      4.564540,
      NULL,
      19.848568,
      1,
      11,
      21,
      79.492375,
      21.408781,
      46,
      11,
      95,
      11,
      NULL,
      14,
      NULL,
      32.207347,
      197.410156,
      NULL,
      109,
      ' 1- 3-1975',
      43,
      22,
      8,
      16.315473,
      218,
      64,
      ' 2-15-1995',
      0.374095,
      2.231552,
      1,
      1.461776,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5.342631,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-19-1988',
      NULL,
      65,
      56.290968,
      26.960283,
      35,
      NULL,
      74,
      NULL,
      37,
      0,
      52,
      NULL,
      '11-20-1986',
      15,
      19,
      13,
      47,
      41.327532,
      64,
      4,
      ' 8- 9-1982',
      3,
      2.785532,
      ' 3-12-2002',
      5,
      NULL,
      9.207693,
      NULL,
      7.381037,
      2.060791,
      NULL,
      15.163322,
      NULL,
      65.449761,
      0.772734,
      1.793917,
      20.544369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 4-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      2.192939,
      NULL,
      ' 1-20-1977',
      1,
      80.500491,
      ' 6-25-1999',
      14,
      NULL,
      17,
      NULL,
      ' 4-15-1978',
      42.931424,
      1,
      NULL,
      ' 6- 4-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      1,
      NULL,
      NULL,
      55.180029,
      14.195532,
      11,
      7,
      NULL,
      9,
      NULL,
      0,
      NULL,
      63,
      NULL,
      3,
      81.164401,
      0.752088,
      3,
      113.821885,
      2.003880,
      0,
      93.259161,
      NULL,
      20.607321,
      NULL,
      1.758576,
      NULL,
      1.849662,
      0,
      0,
      4.597873,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.478235,
      44.457864,
      0,
      0.457062,
      5,
      51.367275,
      0,
      NULL,
      0.270881,
      NULL,
      0.308345,
      3.671445,
      NULL,
      14.579976,
      11,
      38.579579,
      NULL,
      NULL,
      0,
      NULL,
      4,
      3,
      NULL,
      2,
      0,
      0.174566,
      0,
      0.538831,
      NULL,
      ' 9- 3-1992',
      NULL,
      ' 0-12-1978',
      ' 1-29-1976',
      ' 8-17-1987',
      '11-24-1995',
      ' 7-15-1983',
      NULL);
commit;
end;
/


