set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703609';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43132420',
      '12143032',
      '41011413',
      NULL,
      '10234131',
      '12141204',
      NULL,
      '31221103',
      '03032324',
      '24422310',
      '03420031',
      '34333124',
      '12020310',
      '41002031',
      NULL,
      '23002311',
      '02103303',
      '04403424',
      NULL,
      '42113302',
      '31244330',
      NULL,
      '43334012',
      '32111034',
      '11331132',
      '23104403',
      '22013323',
      '24031100',
      NULL,
      '23433442',
      '40333441',
      '13411223',
      NULL,
      '03302133',
      '21000432',
      '44402443',
      NULL,
      '11242301',
      '23414012',
      '00240030',
      '12114124',
      '44330403',
      '32433014',
      '03221332',
      '',
      '',
      NULL,
      NULL,
      '1424202',
      3.300716,
      0.930615,
      NULL,
      NULL,
      '301433',
      3,
      ' 4-26-1991',
      ' 4-15-1994',
      10.442630,
      NULL,
      NULL,
      3.218804,
      39,
      NULL,
      0.113359,
      24.676003,
      15,
      12,
      23.171216,
      15.404857,
      NULL,
      0,
      27,
      14,
      10.177712,
      14.471177,
      NULL,
      7.722140,
      49.021271,
      NULL,
      27.425708,
      1.543712,
      NULL,
      108,
      74,
      41.577506,
      181,
      124,
      122.640987,
      ' 2- 1-1977',
      NULL,
      67,
      30.586850,
      23,
      134.773027,
      NULL,
      ' 2- 0-1991',
      3,
      NULL,
      0.257985,
      7.424056,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307474,
      NULL,
      1.842066,
      0.942922,
      1.519719,
      6.269502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-15-1975',
      NULL,
      118,
      97,
      31,
      99.160644,
      57.698405,
      16,
      NULL,
      69,
      27.064701,
      95.642800,
      NULL,
      ' 0- 6-1976',
      14.662317,
      7,
      26.695434,
      71.944357,
      24.084798,
      12,
      NULL,
      '10-21-1980',
      5,
      18,
      NULL,
      9,
      1.642093,
      4.616543,
      5,
      NULL,
      6.148147,
      NULL,
      13.340237,
      NULL,
      2.507666,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 5-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.520234,
      34,
      23,
      ' 0- 6-1998',
      NULL,
      NULL,
      ' 0-22-1993',
      9,
      13.571041,
      23.350101,
      23,
      NULL,
      NULL,
      0.899765,
      77.030918,
      ' 5-24-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      78.962793,
      NULL,
      NULL,
      59.926332,
      NULL,
      12,
      NULL,
      0,
      13.262641,
      NULL,
      1.419791,
      NULL,
      40,
      1,
      1.394060,
      60,
      1.706201,
      5,
      69,
      1.052078,
      0,
      244,
      NULL,
      15,
      NULL,
      0.186206,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.454755,
      1,
      NULL,
      NULL,
      NULL,
      17.361004,
      NULL,
      NULL,
      0,
      0,
      3.309834,
      1,
      0.325901,
      3,
      28.438488,
      0.349164,
      NULL,
      1.175313,
      NULL,
      0.957663,
      0,
      NULL,
      3.515724,
      NULL,
      16.703750,
      NULL,
      NULL,
      7.944093,
      NULL,
      5,
      5,
      NULL,
      1,
      0,
      1.373934,
      1,
      0.166854,
      NULL,
      ' 1-26-2002',
      ' 0- 4-1982',
      ' 8- 3-1986',
      ' 4- 2-1988',
      ' 4-19-1977',
      ' 7-18-1975',
      ' 2- 1-2001',
      NULL);
commit;
end;
/


