set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2041',
      '34212340',
      '20143310',
      '41142204',
      '20012011',
      '04413230',
      '13233230',
      '23013111',
      NULL,
      '33422414',
      '10143042',
      '01323432',
      '21410424',
      NULL,
      '23124141',
      '02223402',
      '42114224',
      '03312341',
      '40443400',
      '30421324',
      '12143221',
      '22334230',
      '24013221',
      '22111432',
      NULL,
      '40243310',
      '31143203',
      '30004423',
      '02202420',
      '43344422',
      '41032443',
      '20113114',
      '21104310',
      '31022322',
      '32322344',
      NULL,
      '12300123',
      '02102133',
      '14402332',
      '24421443',
      '44113043',
      '22011403',
      NULL,
      '13243244',
      NULL,
      '111',
      '20',
      20.767925,
      12.895571,
      '1132140',
      0.451455,
      1,
      3,
      NULL,
      '332144',
      3.702625,
      NULL,
      '11- 1-1991',
      NULL,
      65.983355,
      14,
      2.299493,
      0,
      14,
      35,
      5.352146,
      NULL,
      NULL,
      4,
      4.276278,
      16.116738,
      4,
      8,
      0,
      6.958574,
      NULL,
      35.702643,
      NULL,
      NULL,
      2.604298,
      66,
      8,
      NULL,
      63.138812,
      110.611086,
      60,
      NULL,
      129,
      103,
      ' 7-11-1978',
      5,
      16,
      5,
      15,
      NULL,
      57.274617,
      ' 5-16-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34.268047,
      12.403571,
      47,
      6,
      19.197708,
      3,
      ' 3- 8-1977',
      0,
      0,
      41,
      0.516655,
      0.058878,
      25.272258,
      NULL,
      3.923217,
      14.727134,
      NULL,
      NULL,
      NULL,
      ' 6- 0-2000',
      27,
      39.523244,
      12,
      15,
      33,
      43,
      34,
      57,
      NULL,
      32.554752,
      65.861477,
      52,
      NULL,
      27.105435,
      12.141000,
      22.704405,
      NULL,
      NULL,
      50.526946,
      13,
      '11-11-1991',
      NULL,
      0,
      ' 3-22-1992',
      NULL,
      3.419970,
      12,
      4,
      NULL,
      NULL,
      1.195805,
      4.980402,
      NULL,
      30,
      1,
      1.247597,
      1.400079,
      NULL,
      3,
      NULL,
      1,
      1,
      ' 0-15-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.392714,
      '10-11-2001',
      NULL,
      NULL,
      NULL,
      7.307617,
      ' 9- 0-1990',
      NULL,
      '10- 4-1985',
      NULL,
      7.387186,
      ' 1-11-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      13,
      ' 2-15-1979',
      48.831287,
      17.753189,
      NULL,
      ' 6- 5-1975',
      0,
      96,
      NULL,
      9,
      14.912011,
      NULL,
      NULL,
      ' 2-28-2000',
      63,
      1,
      158.885415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


