set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      '1',
      '3',
      '1',
      '4',
      '2',
      NULL,
      '1',
      '0',
      '1',
      '4',
      '0',
      '3',
      NULL,
      '0',
      NULL,
      '3',
      '4',
      '0',
      '4',
      '4',
      '1',
      '4',
      '',
      '2',
      '',
      '0',
      '1',
      '1',
      '0',
      NULL,
      '',
      '',
      '3',
      '2',
      NULL,
      '3',
      '2',
      '0',
      '4',
      '2',
      NULL,
      '0',
      '2',
      '022',
      NULL,
      31,
      21.121048,
      '3421133',
      NULL,
      20.777550,
      0,
      NULL,
      '234140',
      5,
      ' 3- 0-1991',
      NULL,
      31,
      78,
      NULL,
      NULL,
      29.413122,
      5,
      41.316195,
      11.503784,
      6,
      7,
      12,
      3.704952,
      24,
      0,
      11.204469,
      11.651063,
      20,
      NULL,
      19,
      8.654776,
      10.645229,
      10.299631,
      26,
      NULL,
      NULL,
      36.351796,
      26.705790,
      71,
      85,
      144.692217,
      NULL,
      ' 4-24-1991',
      5,
      26,
      18.320900,
      23,
      149,
      116,
      '11-14-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      41,
      5.949523,
      29,
      1.580032,
      ' 0- 1-1990',
      1,
      0,
      39.873932,
      0.236493,
      1.095106,
      61,
      0,
      1,
      46.254540,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      NULL,
      36.795804,
      NULL,
      NULL,
      24.277376,
      15,
      51.844408,
      0,
      NULL,
      42.894860,
      NULL,
      ' 3-14-1983',
      29.164044,
      10.316949,
      6.439420,
      63.048922,
      32,
      54.492265,
      11,
      ' 1-21-1975',
      15.877577,
      NULL,
      '10-13-1978',
      0.324880,
      6,
      NULL,
      NULL,
      20,
      9,
      NULL,
      15,
      1,
      93,
      0.509414,
      0.028063,
      7,
      NULL,
      1.405208,
      13,
      3,
      3,
      ' 2- 9-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      66.454245,
      NULL,
      '10-17-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-17-1985',
      NULL,
      ' 8-23-1985',
      13,
      4,
      ' 7- 1-1985',
      27,
      83,
      ' 7- 0-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      7,
      '10-18-1997',
      51.004212,
      6,
      12,
      NULL,
      0,
      58,
      '10- 3-1989',
      8,
      NULL,
      9.982885,
      1,
      '10-14-1993',
      16,
      1.669413,
      NULL,
      '10-19-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


