set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      '1',
      '2',
      NULL,
      '0',
      '1',
      '0',
      NULL,
      '4',
      '4',
      '2',
      '0',
      '4',
      '0',
      '4',
      '2',
      '3',
      '0',
      '3',
      '1',
      NULL,
      '0',
      '',
      '3',
      NULL,
      '0',
      NULL,
      '3',
      '3',
      '3',
      '',
      '',
      '1',
      '1',
      NULL,
      '2',
      NULL,
      NULL,
      '1',
      '3',
      '4',
      '0',
      '0',
      '404',
      '00234123',
      41.246564,
      43,
      '3200211',
      3.292938,
      11,
      1,
      NULL,
      '324230',
      4.763791,
      NULL,
      ' 9- 5-2000',
      247.884558,
      109,
      9.983092,
      5,
      19.207216,
      7.356648,
      22.023091,
      NULL,
      1,
      14.194785,
      12.363659,
      4,
      NULL,
      4.146674,
      17,
      NULL,
      6.151372,
      2,
      15,
      8,
      23,
      2,
      NULL,
      15,
      1,
      17,
      89.945042,
      17,
      0.784590,
      93,
      84.708575,
      ' 9- 3-1979',
      37,
      0,
      5.933206,
      NULL,
      58,
      40,
      ' 4-15-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      88.065276,
      39,
      7.777819,
      29.060850,
      10,
      1.327281,
      ' 5-10-1975',
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.867827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-24-1996',
      NULL,
      64.343047,
      19.716880,
      NULL,
      0,
      80.558428,
      19,
      NULL,
      35.347431,
      NULL,
      68,
      17.806764,
      ' 6-11-1982',
      13.902476,
      13.546478,
      NULL,
      1,
      59,
      39.454767,
      7.746327,
      ' 5- 9-1986',
      11,
      5.271445,
      ' 7-13-1988',
      1.915703,
      2.321944,
      11,
      10.660350,
      NULL,
      6,
      2.283147,
      13.206738,
      NULL,
      NULL,
      0.724354,
      1,
      2,
      NULL,
      3.404363,
      1,
      1,
      5,
      ' 0-12-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 3-1977',
      NULL,
      ' 4- 9-1989',
      NULL,
      2.926134,
      ' 0-15-1985',
      38.437251,
      44.670456,
      ' 3-27-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      ' 6-11-1992',
      NULL,
      0,
      9.693992,
      '10-15-1991',
      1.063515,
      17.607771,
      NULL,
      NULL,
      18.756376,
      2.029499,
      NULL,
      ' 5-27-1996',
      59,
      1.580213,
      127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


