set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8929786';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4420',
      '04301001',
      '00230334',
      NULL,
      NULL,
      '20004240',
      NULL,
      '41010222',
      '12242302',
      '04210020',
      NULL,
      NULL,
      NULL,
      '03211334',
      NULL,
      NULL,
      '12211132',
      '03203124',
      '33234001',
      '33122210',
      '02003132',
      '44421312',
      '42314221',
      '43322234',
      '30330201',
      '04004131',
      '22122041',
      '23024411',
      '33444113',
      '31012424',
      '23202422',
      NULL,
      '31220344',
      NULL,
      '20021333',
      NULL,
      '31400144',
      '33111410',
      '11422101',
      '23344012',
      '13030331',
      '40121031',
      '12424411',
      '40341030',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      2.633711,
      0,
      2,
      NULL,
      '031220',
      NULL,
      ' 2- 6-1996',
      ' 2- 7-1993',
      11,
      NULL,
      NULL,
      13,
      26,
      NULL,
      NULL,
      1,
      8,
      NULL,
      25.953175,
      16.011390,
      25.364621,
      15,
      14.364972,
      14.348418,
      NULL,
      15.825281,
      NULL,
      0.581206,
      19,
      1,
      31,
      3.686666,
      NULL,
      36,
      NULL,
      29,
      141.856595,
      20,
      130.911055,
      '11-14-1991',
      43.366370,
      22,
      16,
      13,
      124.851066,
      112.010039,
      ' 6-16-1979',
      1.584252,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-24-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-16-1979',
      49.123772,
      NULL,
      52,
      37.393489,
      13,
      54.331580,
      62,
      49,
      NULL,
      31,
      68,
      NULL,
      ' 9-16-1994',
      11,
      2.977135,
      10.581832,
      11,
      NULL,
      133.611606,
      7,
      ' 4-21-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      11.284081,
      23,
      19,
      10,
      11,
      NULL,
      2,
      NULL,
      118.719258,
      6.717387,
      19,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-11-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.039311,
      15.908548,
      13,
      ' 7- 1-1992',
      NULL,
      NULL,
      ' 3-28-1979',
      2,
      26.256794,
      19,
      28,
      ' 1-20-2001',
      70.792342,
      1,
      109.028642,
      NULL,
      NULL,
      NULL,
      NULL,
      84.033364,
      31.353260,
      60,
      NULL,
      66,
      82.806805,
      4,
      8.395042,
      NULL,
      8.997668,
      NULL,
      82,
      NULL,
      0,
      NULL,
      NULL,
      0,
      29,
      NULL,
      NULL,
      99,
      0.062314,
      1,
      22,
      44,
      11.933979,
      74.034663,
      NULL,
      15.519375,
      NULL,
      NULL,
      1,
      0.424115,
      0,
      0,
      48,
      61.761573,
      NULL,
      17.855652,
      NULL,
      42.438422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      53,
      0.814099,
      1,
      47.764565,
      22.733560,
      NULL,
      NULL,
      10,
      NULL,
      22.938853,
      55.937760,
      NULL,
      1,
      1.989597,
      0.917989,
      0,
      1,
      1.271934,
      0,
      NULL,
      ' 2-23-1984',
      ' 7- 3-1989',
      '10-20-1989',
      NULL,
      ' 7-22-1991',
      NULL,
      ' 6- 9-1996',
      NULL);
commit;
end;
/


